/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.Iterator;
import java.util.LinkedList;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLLogHandler
extends AbstractXMLHandler
implements ISVNLogEntryHandler {
    public static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    public static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    public static final String ACTION_ATTR = "action";
    public static final String REVISION_ATTR = "revision";
    public static final String MSG_TAG = "msg";
    public static final String PATH_TAG = "path";
    public static final String PATHS_TAG = "paths";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String LOGENTRY_TAG = "logentry";
    public static final String LOG_TAG = "log";
    private boolean myIsOmitLogMessage;
    private LinkedList myMergeStack;

    public SVNXMLLogHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLLogHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        super(contentHandler, log);
    }

    public String getHeaderName() {
        return LOG_TAG;
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        try {
            this.sendToHandler(logEntry);
        }
        catch (SAXException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
    }

    public void setOmitLogMessage(boolean omitLogMessage) {
        this.myIsOmitLogMessage = omitLogMessage;
    }

    private void sendToHandler(SVNLogEntry logEntry) throws SAXException {
        MergeFrame frame;
        if (logEntry.getRevision() == 0L && logEntry.getMessage() == null) {
            return;
        }
        this.addAttribute(REVISION_ATTR, logEntry.getRevision() + "");
        this.openTag(LOGENTRY_TAG);
        if (logEntry.getAuthor() != null) {
            this.addTag(AUTHOR_TAG, logEntry.getAuthor());
        }
        if (logEntry.getDate() != null && logEntry.getDate().getTime() != 0L) {
            this.addTag(DATE_TAG, SVNDate.formatDate(logEntry.getDate()));
        }
        if (logEntry.getChangedPaths() != null && !logEntry.getChangedPaths().isEmpty()) {
            this.openTag(PATHS_TAG);
            Iterator paths = logEntry.getChangedPaths().keySet().iterator();
            while (paths.hasNext()) {
                String key = (String)paths.next();
                SVNLogEntryPath path = (SVNLogEntryPath)logEntry.getChangedPaths().get(key);
                this.addAttribute(ACTION_ATTR, path.getType() + "");
                if (path.getCopyPath() != null) {
                    this.addAttribute(COPYFROM_PATH_ATTR, path.getCopyPath());
                    this.addAttribute(COPYFROM_REV_ATTR, path.getCopyRevision() + "");
                }
                this.addTag(PATH_TAG, path.getPath());
            }
            this.closeTag(PATHS_TAG);
        }
        if (!this.myIsOmitLogMessage) {
            String message = logEntry.getMessage();
            message = message == null ? "" : message;
            this.addTag(MSG_TAG, message);
        }
        if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) {
            frame = (MergeFrame)this.myMergeStack.getLast();
            frame.myNumberOfChildrenRemaining--;
        }
        if (logEntry.hasChildren()) {
            frame = new MergeFrame();
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(frame);
        } else {
            while (this.myMergeStack != null && !this.myMergeStack.isEmpty() && (frame = (MergeFrame)this.myMergeStack.getLast()).myNumberOfChildrenRemaining == 0L) {
                this.closeTag(LOGENTRY_TAG);
                this.myMergeStack.removeLast();
            }
            this.closeTag(LOGENTRY_TAG);
        }
    }

    private class MergeFrame {
        private long myNumberOfChildrenRemaining;

        private MergeFrame() {
        }
    }
}

