/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;

public class SqlJetBtreeTable
implements ISqlJetBtreeTable {
    private static final int CURSOR_LOCK_RETRIES = SqlJetUtility.getIntSysProp("SqlJetBtreeTable.CURSOR_LOCK_RETRIES", 1000);
    private static final long CURSOR_LOCK_SLEEP_MS = SqlJetUtility.getIntSysProp("SqlJetBtreeTable.CURSOR_LOCK_SLEEP_MS", 10);
    protected static String AUTOINDEX = "sqlite_autoindex_%s_%d";
    protected ISqlJetDbHandle db;
    protected ISqlJetBtree btree;
    protected int rootPage;
    protected boolean write;
    protected boolean index;
    protected ISqlJetBtreeCursor cursor;
    protected SqlJetKeyInfo keyInfo;
    private long priorNewRowid = 0L;
    private SqlJetBtreeRecord recordCache;
    private Object[] valueCache;
    private Object[] valuesCache;

    public SqlJetBtreeTable(ISqlJetDbHandle db, ISqlJetBtree btree, int rootPage, boolean write, boolean index) throws SqlJetException {
        this.init(db, btree, rootPage, write, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ISqlJetDbHandle db, ISqlJetBtree btree, int rootPage, boolean write, boolean index) throws SqlJetException {
        this.db = db;
        this.btree = btree;
        this.rootPage = rootPage;
        this.write = write;
        this.index = index;
        if (index) {
            this.keyInfo = new SqlJetKeyInfo();
            this.keyInfo.setEnc(db.getOptions().getEncoding());
        }
        for (int i = 0; i < CURSOR_LOCK_RETRIES; ++i) {
            try {
                this.cursor = btree.getCursor(rootPage, write, index ? this.keyInfo : null);
                break;
            }
            catch (SqlJetException e) {
                if (SqlJetErrorCode.LOCKED == e.getErrorCode()) {
                    try {
                        db.getMutex().leave();
                        Thread.sleep(CURSOR_LOCK_SLEEP_MS);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        return;
                    }
                    finally {
                        db.getMutex().enter();
                    }
                }
                throw e;
            }
        }
        this.first();
    }

    public void close() throws SqlJetException {
        this.clearRecordCache();
        this.cursor.closeCursor();
    }

    public void unlock() {
        this.cursor.leaveCursor();
    }

    public void lock() throws SqlJetException {
        this.cursor.enterCursor();
    }

    public boolean eof() throws SqlJetException {
        this.hasMoved();
        return this.cursor.eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoved() throws SqlJetException {
        this.cursor.enterCursor();
        try {
            boolean bl = this.cursor.cursorHasMoved();
            return bl;
        }
        finally {
            this.cursor.leaveCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            boolean bl = !this.cursor.first();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            boolean bl = !this.cursor.last();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            this.hasMoved();
            boolean bl = !this.cursor.next();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            this.hasMoved();
            boolean bl = !this.cursor.previous();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetBtreeRecord getRecord() throws SqlJetException {
        if (this.eof()) {
            return null;
        }
        if (null == this.recordCache) {
            this.lock();
            try {
                this.recordCache = new SqlJetBtreeRecord(this.cursor, this.index, this.db.getOptions().getFileFormat());
            }
            finally {
                this.unlock();
            }
            this.valueCache = new Object[this.recordCache.getFieldsCount()];
        }
        return this.recordCache;
    }

    public void lockTable(boolean write) {
        this.btree.lockTable(this.rootPage, write);
    }

    public SqlJetEncoding getEncoding() throws SqlJetException {
        return this.cursor.getCursorDb().getOptions().getEncoding();
    }

    protected static boolean checkField(ISqlJetBtreeRecord record, int field) throws SqlJetException {
        return field >= 0 && record != null && field < record.getFieldsCount();
    }

    protected ISqlJetVdbeMem getValueMem(int field) throws SqlJetException {
        ISqlJetBtreeRecord r = this.getRecord();
        if (null == r) {
            return null;
        }
        if (!SqlJetBtreeTable.checkField(r, field)) {
            return null;
        }
        List<ISqlJetVdbeMem> fields = r.getFields();
        if (null == fields) {
            return null;
        }
        return fields.get(field);
    }

    public Object getValue(int field) throws SqlJetException {
        Object valueCached;
        if (this.valueCache != null && field < this.valueCache.length && (valueCached = this.valueCache[field]) != null) {
            return valueCached;
        }
        Object valueUncached = this.getValueUncached(field);
        if (valueUncached != null) {
            this.valueCache[field] = valueUncached;
        }
        return valueUncached;
    }

    public Object getValueUncached(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return null;
        }
        switch (value.getType()) {
            case INTEGER: {
                return value.intValue();
            }
            case FLOAT: {
                return value.realValue();
            }
            case TEXT: {
                return SqlJetUtility.toString(value.valueText(this.getEncoding()), this.getEncoding());
            }
            case BLOB: {
                return value.valueBlob();
            }
            case NULL: {
                break;
            }
        }
        return null;
    }

    public int getFieldsCount() throws SqlJetException {
        ISqlJetBtreeRecord r = this.getRecord();
        if (null == r) {
            return 0;
        }
        return r.getFieldsCount();
    }

    public boolean isNull(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (null == value) {
            return true;
        }
        return value.isNull();
    }

    public String getString(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return null;
        }
        return SqlJetUtility.toString(value.valueText(this.getEncoding()), this.getEncoding());
    }

    public long getInteger(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return 0L;
        }
        return value.intValue();
    }

    public double getFloat(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return 0.0;
        }
        return value.realValue();
    }

    public SqlJetValueType getFieldType(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null) {
            return SqlJetValueType.NULL;
        }
        return value.getType();
    }

    public ByteBuffer getBlob(int field) throws SqlJetException {
        ISqlJetVdbeMem value = this.getValueMem(field);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.valueBlob();
    }

    public Object[] getValues() throws SqlJetException {
        if (this.valuesCache != null) {
            return this.valuesCache;
        }
        ISqlJetBtreeRecord record = this.getRecord();
        int fieldsCount = record.getFieldsCount();
        for (int i = 0; i < fieldsCount; ++i) {
            this.valueCache[i] = this.getValue(i);
        }
        this.valuesCache = this.valueCache;
        return this.valueCache;
    }

    public long newRowId() throws SqlJetException {
        return this.newRowId(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long newRowId(long prev) throws SqlJetException {
        this.lock();
        try {
            boolean useRandomRowid = false;
            long v = 0L;
            int res = 0;
            int cnt = 0;
            if ((this.cursor.flags() & (SqlJetBtreeTableCreateFlags.INTKEY.getValue() | SqlJetBtreeTableCreateFlags.ZERODATA.getValue())) != SqlJetBtreeTableCreateFlags.INTKEY.getValue()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert ((this.cursor.flags() & SqlJetBtreeTableCreateFlags.INTKEY.getValue()) != 0);
            assert ((this.cursor.flags() & SqlJetBtreeTableCreateFlags.ZERODATA.getValue()) == 0);
            long MAX_ROWID = Integer.MAX_VALUE;
            boolean last = this.cursor.last();
            if (last) {
                v = 1L;
            } else {
                v = this.cursor.getKeySize();
                if (v == MAX_ROWID) {
                    useRandomRowid = true;
                } else {
                    ++v;
                }
                if (prev != 0L) {
                    if (prev == MAX_ROWID || useRandomRowid) {
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                    if (v < prev) {
                        v = prev + 1L;
                    }
                }
                if (useRandomRowid) {
                    v = this.priorNewRowid;
                    Random random = new Random();
                    assert (prev == 0L);
                    cnt = 0;
                    do {
                        if (cnt == 0 && (v & 0xFFFFFFL) == v) {
                            ++v;
                        } else {
                            v = random.nextInt();
                            if (cnt < 5) {
                                v &= 0xFFFFFFL;
                            }
                        }
                        if (v == 0L) continue;
                        res = this.cursor.moveToUnpacked(null, v, false);
                        ++cnt;
                    } while (cnt < 100 && res == 0);
                    this.priorNewRowid = v;
                    if (res == 0) {
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                }
            }
            long l = v;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    public ISqlJetBtreeCursor getCursor() {
        return this.cursor;
    }

    public static String generateAutoIndexName(String tableName, int i) {
        return String.format(AUTOINDEX, tableName, i);
    }

    protected void clearRecordCache() {
        this.recordCache = null;
        this.valuesCache = null;
        this.valueCache = null;
    }

    public void clear() throws SqlJetException {
        this.btree.clearTable(this.rootPage, null);
    }
}

