/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReader {
    private static final String DEAFAULT_ERROR_TEMPLATE = "nssn";
    private static final String DEFAULT_TEMPLATE = "wl";
    private static final String UTF8_CHARSET_STRING = "UTF-8";

    public static Date getDate(List items, int index) {
        String str = SVNReader.getString(items, index);
        return SVNDate.parseDate(str);
    }

    public static long getLong(List items, int index) {
        if (items == null || index >= items.size()) {
            return -1L;
        }
        Object item = items.get(index);
        if (item instanceof Long) {
            return (Long)item;
        }
        return -1L;
    }

    public static boolean getBoolean(List items, int index) {
        if (items == null || index >= items.size()) {
            return false;
        }
        Object item = items.get(index);
        if (item instanceof String) {
            return Boolean.valueOf((String)item);
        }
        return false;
    }

    public static List getList(List items, int index) {
        if (items == null || index >= items.size()) {
            return Collections.EMPTY_LIST;
        }
        Object item = items.get(index);
        if (item instanceof List) {
            List list = (List)item;
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof SVNItem)) continue;
                SVNItem svnItem = (SVNItem)list.get(i);
                if (svnItem.getKind() == 1) {
                    list.set(i, svnItem.getBytes());
                    continue;
                }
                if (svnItem.getKind() == 0) {
                    list.set(i, svnItem.getWord());
                    continue;
                }
                if (svnItem.getKind() != 3) continue;
                list.set(i, new Long(svnItem.getNumber()));
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public static SVNProperties getProperties(List items, int index, SVNProperties properties) throws SVNException {
        SVNProperties sVNProperties = properties = properties == null ? new SVNProperties() : properties;
        if (items == null || index >= items.size()) {
            return properties;
        }
        if (!(items.get(index) instanceof List)) {
            return properties;
        }
        List props = SVNReader.getItemList(items, index);
        Iterator prop = props.iterator();
        while (prop.hasNext()) {
            SVNItem item = (SVNItem)prop.next();
            if (item.getKind() != 2) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Proplist element not a list");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            List propItems = SVNReader.parseTuple("sb", item.getItems(), null);
            properties.put(SVNReader.getString(propItems, 0), SVNReader.getBytes(propItems, 1));
        }
        return properties;
    }

    public static SVNProperties getPropertyDiffs(List items, int index, SVNProperties diffs) throws SVNException {
        if (items == null || index >= items.size()) {
            return diffs;
        }
        if (!(items.get(index) instanceof List)) {
            return diffs;
        }
        diffs = diffs == null ? new SVNProperties() : diffs;
        items = SVNReader.getList(items, index);
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            SVNItem item = (SVNItem)iterator.next();
            if (item.getKind() != 2) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Prop diffs element not a list");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            List values = SVNReader.parseTuple("s(?b)", item.getItems(), null);
            diffs.put(SVNReader.getString(values, 0), SVNReader.getBytes(values, 1));
        }
        return diffs;
    }

    public static SVNLock getLock(Collection items) throws SVNException {
        List values = SVNReader.parseTuple("sss(?s)s(?s)", items, null);
        String path = SVNPathUtil.canonicalizePath(SVNReader.getString(values, 0));
        String token = SVNReader.getString(values, 1);
        String owner = SVNReader.getString(values, 2);
        String comment = SVNReader.getString(values, 3);
        Date creationDate = SVNReader.getDate(values, 4);
        Date expirationDate = null;
        if (values.size() >= 6 && values.get(5) != null) {
            expirationDate = SVNReader.getDate(values, 5);
        }
        return new SVNLock(path, token, owner, comment, creationDate, expirationDate);
    }

    public static String getString(List items, int index) {
        if (items == null || index >= items.size()) {
            return null;
        }
        Object item = items.get(index);
        if (item instanceof byte[]) {
            try {
                return new String((byte[])item, UTF8_CHARSET_STRING);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (item instanceof String) {
            return (String)item;
        }
        if (item instanceof Long) {
            return item.toString();
        }
        return null;
    }

    public static byte[] getBytes(List items, int index) {
        if (items == null || index >= items.size()) {
            return null;
        }
        Object item = items.get(index);
        if (item instanceof byte[]) {
            return (byte[])item;
        }
        if (item instanceof String) {
            try {
                return ((String)item).getBytes(UTF8_CHARSET_STRING);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static List getItemList(List items, int index) {
        if (items == null || index >= items.size()) {
            return Collections.EMPTY_LIST;
        }
        if (items.get(index) instanceof List) {
            return (List)items.get(index);
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean hasValue(List items, int index, Object value) {
        if (items == null || index >= items.size()) {
            return false;
        }
        if (items.get(index) instanceof List) {
            Iterator iter = ((List)items.get(index)).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!element.equals(value)) continue;
                return true;
            }
        } else {
            if (items.get(index) == null) {
                return value == null;
            }
            if (items.get(index) instanceof byte[] && value instanceof String) {
                try {
                    items.set(index, new String((byte[])items.get(index), UTF8_CHARSET_STRING));
                }
                catch (IOException e) {
                    return false;
                }
            }
            return items.get(index).equals(value);
        }
        return false;
    }

    public static SVNItem readItem(InputStream is) throws SVNException {
        char ch = SVNReader.skipWhiteSpace(is);
        return SVNReader.readItem(is, null, ch);
    }

    public static List parse(InputStream is, String template, List values) throws SVNException {
        List readItems = SVNReader.readTuple(is, DEFAULT_TEMPLATE);
        String word = SVNReader.getString(readItems, 0);
        List list = SVNReader.getItemList(readItems, 1);
        if ("success".equals(word)) {
            return SVNReader.parseTuple(template, list, values);
        }
        if ("failure".equals(word)) {
            SVNReader.handleFailureStatus(list);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Unknown status ''{0}'' in command response", word);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return null;
    }

    public static void handleFailureStatus(List list) throws SVNException {
        SVNErrorMessage topError;
        if (list.size() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Empty error list");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        SVNErrorMessage parentError = topError = SVNReader.getErrorMessage((SVNItem)list.get(list.size() - 1));
        for (int i = list.size() - 2; i >= 0; --i) {
            SVNItem item = (SVNItem)list.get(i);
            SVNErrorMessage error = SVNReader.getErrorMessage(item);
            parentError.setChildErrorMessage(error);
            parentError = error;
        }
        SVNErrorManager.error(topError, SVNLogType.NETWORK);
    }

    private static SVNErrorMessage getErrorMessage(SVNItem item) throws SVNException {
        if (item.getKind() != 2) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed error list");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        List errorItems = SVNReader.parseTuple(DEAFAULT_ERROR_TEMPLATE, item.getItems(), null);
        int code = ((Long)errorItems.get(0)).intValue();
        SVNErrorCode errorCode = SVNErrorCode.getErrorCode(code);
        String errorMessage = SVNReader.getString(errorItems, 1);
        errorMessage = errorMessage == null ? "" : errorMessage;
        return SVNErrorMessage.create(errorCode, errorMessage);
    }

    public static List readTuple(InputStream is, String template) throws SVNException {
        char ch = SVNReader.skipWhiteSpace(is);
        SVNItem item = SVNReader.readItem(is, null, ch);
        if (item.getKind() != 2) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return SVNReader.parseTuple(template, item.getItems(), null);
    }

    public static List parseTuple(String template, Collection items, List values) throws SVNException {
        values = values == null ? new ArrayList() : values;
        SVNReader.parseTuple(template, 0, items, values);
        return values;
    }

    private static int parseTuple(String template, int index, Collection items, List values) throws SVNException {
        values = values == null ? new ArrayList() : values;
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && index < template.length()) {
            SVNItem item = (SVNItem)iterator.next();
            char ch = template.charAt(index);
            if (ch == '?') {
                ch = template.charAt(++index);
            }
            if ((ch == 'n' || ch == 'r') && item.getKind() == 3) {
                values.add(new Long(item.getNumber()));
            } else if (ch == 's' && item.getKind() == 1) {
                try {
                    values.add(new String(item.getBytes(), UTF8_CHARSET_STRING));
                }
                catch (IOException e) {
                    values.add(item.getBytes());
                }
            } else if (ch == 's' && item.getKind() == 0) {
                values.add(item.getWord());
            } else if (ch == 'b' && item.getKind() == 1) {
                values.add(item.getBytes());
            } else if (ch == 'w' && item.getKind() == 0) {
                values.add(item.getWord());
            } else if (ch == 'l' && item.getKind() == 2) {
                values.add(item.getItems());
            } else if (ch == '(' && item.getKind() == 2) {
                ++index;
                index = SVNReader.parseTuple(template, index, item.getItems(), values);
            } else {
                if (ch != ')') break;
                return ++index;
            }
            ++index;
        }
        if (index < template.length() && template.charAt(index) == '?') {
            int nestingLevel = 0;
            while (index < template.length()) {
                switch (template.charAt(index)) {
                    case '?': {
                        break;
                    }
                    case 'n': 
                    case 'r': {
                        values.add(new Long(-1L));
                        break;
                    }
                    case 'b': 
                    case 's': 
                    case 'w': {
                        values.add(null);
                        break;
                    }
                    case 'l': {
                        values.add(Collections.EMPTY_LIST);
                        break;
                    }
                    case '(': {
                        ++nestingLevel;
                        break;
                    }
                    case ')': {
                        if (--nestingLevel >= 0) break;
                        return index;
                    }
                    default: {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                }
                ++index;
            }
        }
        if (index == template.length() - 1 && template.charAt(index) != ')') {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return index;
    }

    private static SVNItem readItem(InputStream is, SVNItem item, char ch) throws SVNException {
        if (item == null) {
            item = new SVNItem();
        }
        if (Character.isDigit(ch)) {
            long value = Character.digit(ch, 10);
            while (true) {
                long previousValue = value;
                ch = SVNReader.readChar(is);
                if (!Character.isDigit(ch)) break;
                if (previousValue == (value = value * 10L + (long)Character.digit(ch, 10)) / 10L) continue;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Number is larger than maximum");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (ch == ':') {
                byte[] buffer = new byte[(int)value];
                try {
                    int r;
                    for (int toRead = (int)value; toRead > 0; toRead -= r) {
                        r = is.read(buffer, buffer.length - toRead, toRead);
                        if (r >= 0) continue;
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                }
                catch (IOException e) {
                    SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, e);
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                item.setKind(1);
                item.setLine(buffer);
                ch = SVNReader.readChar(is);
            } else {
                item.setKind(3);
                item.setNumber(value);
            }
        } else if (Character.isLetter(ch)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(ch);
            while (Character.isLetterOrDigit(ch = SVNReader.readChar(is)) || ch == '-') {
                buffer.append(ch);
            }
            item.setKind(0);
            item.setWord(buffer.toString());
        } else if (ch == '(') {
            item.setKind(2);
            item.setItems(new ArrayList());
            while ((ch = SVNReader.skipWhiteSpace(is)) != ')') {
                SVNItem child = new SVNItem();
                item.getItems().add(child);
                SVNReader.readItem(is, child, ch);
            }
            ch = SVNReader.readChar(is);
        }
        if (!Character.isWhitespace(ch)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return item;
    }

    private static char readChar(InputStream is) throws SVNException {
        int r = 0;
        try {
            r = is.read();
            if (r < 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, e);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return (char)(r & 0xFF);
    }

    private static char skipWhiteSpace(InputStream is) throws SVNException {
        char ch;
        while (Character.isWhitespace(ch = SVNReader.readChar(is))) {
        }
        return ch;
    }
}

