/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.nio.ByteBuffer;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetCollSeq;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;

public class SqlJetKeyInfo
implements ISqlJetKeyInfo {
    ISqlJetDbHandle db;
    SqlJetEncoding enc;
    int nField;
    boolean[] aSortOrder;
    ISqlJetCollSeq[] aColl;

    public SqlJetUnpackedRecord recordUnpack(int nKey, ByteBuffer pKey) {
        int u;
        SqlJetKeyInfo pKeyInfo = this;
        int[] szHdr = new int[1];
        SqlJetUnpackedRecord p = new SqlJetUnpackedRecord();
        p.flags = SqlJetUtility.of(SqlJetUnpackedRecordFlags.NEED_DESTROY);
        p.pKeyInfo = pKeyInfo;
        p.nField = pKeyInfo.nField + 1;
        SqlJetVdbeMem[] pMem = new SqlJetVdbeMem[p.nField];
        p.aMem = pMem;
        int idx = SqlJetUtility.getVarint32(pKey, szHdr);
        int d = szHdr[0];
        for (u = 0; idx < szHdr[0] && u < p.nField; ++u) {
            int[] serial_type = new int[1];
            idx += SqlJetUtility.getVarint32(SqlJetUtility.slice(pKey, idx), serial_type);
            if (d >= nKey && SqlJetVdbeSerialType.serialTypeLen(serial_type[0]) > 0) break;
            pMem[u] = new SqlJetVdbeMem();
            pMem[u].enc = pKeyInfo.enc;
            pMem[u].db = pKeyInfo.db;
            pMem[u].flags = SqlJetUtility.noneOf(SqlJetVdbeMemFlags.class);
            pMem[u].zMalloc = null;
            d += SqlJetVdbeSerialType.serialGet(SqlJetUtility.slice(pKey, d), serial_type[0], pMem[u]);
        }
        assert (u <= pKeyInfo.nField + 1);
        p.nField = u;
        return p;
    }

    public int getNField() {
        return this.nField;
    }

    public void setNField(int field) {
        this.nField = field;
        this.aSortOrder = new boolean[this.nField];
        this.aColl = new ISqlJetCollSeq[this.nField];
    }

    public SqlJetEncoding getEnc() {
        return this.enc;
    }

    public void setEnc(SqlJetEncoding enc) {
        this.enc = enc;
    }

    public void setSortOrder(int i, boolean desc) throws SqlJetException {
        if (i >= this.nField) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.aSortOrder[i] = desc;
    }

    public boolean getSortOrder(int i) throws SqlJetException {
        if (i >= this.nField) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        return this.aSortOrder[i];
    }

    public void setCollating(int i, ISqlJetCollSeq coll) throws SqlJetException {
        if (i >= this.nField) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.aColl[i] = coll;
    }

    public ISqlJetCollSeq getCollating(int i) throws SqlJetException {
        if (i >= this.nField) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        return this.aColl[i];
    }
}

