/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetLimits;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetDeviceCharacteristics;
import org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerLockingMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetSavepointOperation;
import org.tmatesoft.sqljet.core.internal.SqlJetSyncFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPage;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPagerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetPager
implements ISqlJetPager,
ISqlJetLimits,
ISqlJetPageCallback {
    static final String SQLJET_PAGER_LOGGER = "SQLJET_PAGER";
    private static Logger logger = Logger.getLogger("SQLJET_PAGER");
    private static final boolean SQLJET_PAGER_LOG = SqlJetUtility.getBoolSysProp("SQLJET_PAGER_LOG", false);
    private static final int MAX_SECTOR_SIZE = 0x100000;
    ISqlJetFileSystem fileSystem;
    SqlJetFileType type;
    Set<SqlJetFileOpenPermission> permissions;
    SqlJetPagerState state = SqlJetPagerState.UNLOCK;
    SqlJetPagerJournalMode journalMode = SqlJetPagerJournalMode.DELETE;
    SqlJetPagerLockingMode lockingMode = SqlJetPagerLockingMode.NORMAL;
    boolean journalOpen;
    boolean journalStarted;
    boolean useJournal;
    boolean noReadlock;
    boolean noSync;
    boolean fullSync;
    Set<SqlJetSyncFlags> syncFlags;
    boolean tempFile;
    boolean readOnly;
    boolean needSync;
    boolean dirtyCache;
    boolean memDb;
    boolean setMaster;
    boolean doNotSync;
    boolean dbModified;
    boolean changeCountDone;
    boolean dbSizeValid;
    int dbSize;
    int dbOrigSize;
    int dbFileSize;
    int nRec;
    long cksumInit;
    int stmtNRec;
    int pageSize;
    int nPage;
    int mxPage;
    int mxPgno;
    BitSet pagesInJournal;
    BitSet pagesAlwaysRollback;
    File fileName;
    File journal;
    File directory;
    ISqlJetFile fd;
    ISqlJetFile jfd;
    ISqlJetFile sjfd;
    long journalOff;
    long journalHdr;
    int sectorSize;
    ByteBuffer tmpSpace;
    ByteBuffer dbFileVers = ByteBuffer.allocate(16);
    long journalSizeLimit;
    SqlJetPageCache pageCache;
    SqlJetSafetyLevel safetyLevel;
    ISqlJetPageCallback reiniter;
    ISqlJetBusyHandler busyHandler;
    SqlJetErrorCode errCode;
    PagerSavepoint[] aSavepoint;
    int nSavepoint;

    static void PAGERTRACE(String format, Object ... args) {
        if (SQLJET_PAGER_LOG) {
            SqlJetUtility.log(logger, format, args);
        }
    }

    String PAGERID() {
        return this.fileName != null ? this.fileName.getPath() : null;
    }

    String FILEHANDLEID() {
        return this.PAGERID();
    }

    private int JOURNAL_PG_SZ() {
        return this.pageSize + 8;
    }

    private int JOURNAL_HDR_SZ() {
        return this.sectorSize;
    }

    long PAGER_MJ_PGNO() {
        return 0x40000000L / (long)this.pageSize + 1L;
    }

    int int_PAGER_MJ_PGNO() {
        return Long.valueOf(this.PAGER_MJ_PGNO()).intValue();
    }

    static boolean subjRequiresPage(SqlJetPage pPg) {
        int pgno = pPg.pgno;
        SqlJetPager pPager = pPg.pPager;
        for (int i = 0; i < pPager.nSavepoint; ++i) {
            PagerSavepoint p = pPager.aSavepoint[i];
            if (p.nOrig < pgno || SqlJetUtility.bitSetTest(p.pInSavepoint, pgno)) continue;
            return true;
        }
        return false;
    }

    static boolean pageInJournal(SqlJetPage pPg) {
        return SqlJetUtility.bitSetTest(pPg.pPager.pagesInJournal, pPg.pgno);
    }

    @Override
    public void open(ISqlJetFileSystem fileSystem, File fileName, Set<SqlJetPagerFlags> flags, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        this.fileSystem = fileSystem;
        this.type = type;
        this.permissions = permissions;
        this.tempFile = false;
        this.memDb = false;
        this.readOnly = false;
        int szPageDflt = 1024;
        this.useJournal = null == flags || !flags.contains((Object)SqlJetPagerFlags.OMIT_JOURNAL);
        this.fileName = null;
        if (null != fileName) {
            if (":memory:".equals(fileName.getPath())) {
                this.memDb = true;
            } else {
                this.fileName = fileName;
            }
        }
        if (null != this.fileName && !this.memDb) {
            this.directory = this.fileName.getParentFile();
            this.journal = new File(this.directory, this.fileName.getName() + "-journal");
            this.fd = this.fileSystem.open(this.fileName, this.type, this.permissions);
            this.readOnly = this.fd.getPermissions().contains((Object)SqlJetFileOpenPermission.READONLY);
            if (!this.readOnly) {
                Set<SqlJetDeviceCharacteristics> dcs;
                this.setSectorSize();
                if (szPageDflt < this.sectorSize) {
                    szPageDflt = this.sectorSize;
                }
                if (null != (dcs = this.fd.deviceCharacteristics())) {
                    for (SqlJetDeviceCharacteristics dc : dcs) {
                        if (dc.getIoCapAtomicSize() <= 0) continue;
                        szPageDflt = dc.getIoCapAtomicSize();
                    }
                }
                if (szPageDflt > 8192) {
                    szPageDflt = 8192;
                }
            }
        } else {
            this.tempFile = true;
            this.state = SqlJetPagerState.EXCLUSIVE;
        }
        this.tmpSpace = ByteBuffer.allocate(szPageDflt);
        this.pageCache = new SqlJetPageCache();
        this.pageCache.open(szPageDflt, !this.memDb, !this.memDb ? this : null);
        SqlJetPager.PAGERTRACE("OPEN %s %s\n", this.FILEHANDLEID(), fileName);
        this.noReadlock = null != flags && flags.contains((Object)SqlJetPagerFlags.NO_READLOCK) && this.readOnly;
        this.dbSizeValid = this.memDb;
        this.pageSize = szPageDflt;
        this.mxPage = 100;
        this.mxPgno = 0x3FFFFFFF;
        assert (this.state == (this.tempFile ? SqlJetPagerState.EXCLUSIVE : SqlJetPagerState.UNLOCK));
        this.lockingMode = this.tempFile ? SqlJetPagerLockingMode.EXCLUSIVE : SqlJetPagerLockingMode.NORMAL;
        this.noSync = this.tempFile || !this.useJournal;
        this.fullSync = !this.noSync;
        this.syncFlags = SqlJetUtility.of(SqlJetSyncFlags.NORMAL);
        this.journalSizeLimit = SQLJET_DEFAULT_JOURNAL_SIZE_LIMIT;
        this.setSectorSize();
        if (this.memDb) {
            this.journalMode = SqlJetPagerJournalMode.MEMORY;
        }
    }

    private void setSectorSize() {
        assert (null != this.fd || this.tempFile);
        if (!this.tempFile && null != this.fd) {
            this.sectorSize = this.fd.sectorSize();
        }
        if (this.sectorSize < SQLJET_MIN_SECTOR_SIZE) {
            this.sectorSize = SQLJET_MIN_SECTOR_SIZE;
        }
        if (this.sectorSize > 0x100000) {
            this.sectorSize = 0x100000;
        }
    }

    @Override
    public File getDirectoryName() {
        return this.directory;
    }

    @Override
    public File getFileName() {
        return this.fileName;
    }

    @Override
    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public ISqlJetFile getFile() {
        return this.fd;
    }

    @Override
    public File getJournalName() {
        return this.journal;
    }

    @Override
    public boolean isNoSync() {
        return this.noSync;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public SqlJetPagerLockingMode getLockingMode() {
        return this.lockingMode;
    }

    @Override
    public void setLockingMode(SqlJetPagerLockingMode lockingMode) {
        this.lockingMode = lockingMode;
    }

    @Override
    public SqlJetPagerJournalMode getJournalMode() {
        return this.journalMode;
    }

    @Override
    public void setJournalMode(SqlJetPagerJournalMode journalMode) {
        this.journalMode = journalMode;
    }

    @Override
    public long getJournalSizeLimit() {
        return this.journalSizeLimit;
    }

    @Override
    public void setJournalSizeLimit(long limit) {
        if (limit >= -1L) {
            this.journalSizeLimit = limit;
        }
    }

    @Override
    public SqlJetSafetyLevel getSafetyLevel() {
        return this.safetyLevel;
    }

    @Override
    public void setSafetyLevel(SqlJetSafetyLevel safetyLevel) {
        this.safetyLevel = safetyLevel;
        this.noSync = safetyLevel == SqlJetSafetyLevel.OFF || this.tempFile;
        boolean bl = this.fullSync = safetyLevel == SqlJetSafetyLevel.FULL && !this.tempFile;
        if (this.noSync) {
            this.needSync = false;
        }
    }

    @Override
    public ByteBuffer getTempSpace() {
        return this.tmpSpace;
    }

    @Override
    public void setBusyhandler(ISqlJetBusyHandler busyHandler) {
        this.busyHandler = busyHandler;
    }

    @Override
    public void setReiniter(ISqlJetPageCallback reinitier) {
        this.reiniter = reinitier;
    }

    @Override
    public int setPageSize(int pageSize) throws SqlJetException {
        this.checkErrorCode();
        assert (pageSize >= 512 && pageSize <= 32768);
        if (!(pageSize == this.pageSize || this.memDb && this.dbSize != 0 || this.pageCache.getRefCount() != 0)) {
            this.reset();
            this.pageSize = pageSize;
            if (!this.memDb) {
                this.setSectorSize();
            }
            this.tmpSpace = ByteBuffer.allocate(pageSize);
            this.pageCache.setPageSize(pageSize);
        }
        return this.pageSize;
    }

    private void checkErrorCode() throws SqlJetException {
        if (null != this.errCode) {
            throw new SqlJetException(this.errCode);
        }
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    ISqlJetPage lookup(int pageNumber) throws SqlJetException {
        return this.pageCache.fetch(pageNumber, false);
    }

    private void reset() {
        if (null != this.errCode) {
            return;
        }
        if (this.pageCache != null) {
            this.pageCache.clear();
        }
    }

    @Override
    public void setMaxPageCount(int maxPageCount) throws SqlJetException {
        if (maxPageCount > 0) {
            this.mxPgno = maxPageCount;
        }
        this.getPageCount();
    }

    @Override
    public int getMaxPageCount() {
        return this.mxPgno;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.pageCache.setCacheSize(cacheSize);
    }

    @Override
    public int getCacheSize() {
        return this.pageCache.getCachesize();
    }

    @Override
    public void readFileHeader(int count, ByteBuffer buffer) throws SqlJetIOException {
        block4: {
            assert (null != this.fd || this.tempFile);
            if (null != this.fd) {
                try {
                    this.fd.read(buffer, count, 0L);
                }
                catch (SqlJetIOException e) {
                    if (SqlJetIOErrorCode.IOERR_SHORT_READ == e.getIoErrorCode()) break block4;
                    throw e;
                }
            }
        }
    }

    @Override
    public int getPageCount() throws SqlJetException {
        this.checkErrorCode();
        int n = 0;
        if (this.dbSizeValid) {
            n = this.dbSize;
        } else {
            assert (null != this.fd || this.tempFile);
            long l = 0L;
            if (null != this.fd) {
                try {
                    l = this.fd.fileSize();
                }
                catch (SqlJetException e) {
                    this.error(e);
                    throw e;
                }
            }
            n = l > 0L && l < (long)this.pageSize ? 1 : new Long(l /= (long)this.pageSize).intValue();
            if (SqlJetPagerState.UNLOCK != this.state) {
                this.dbSize = n;
                this.dbFileSize = n;
                this.dbSizeValid = true;
            }
        }
        if ((long)n == 0x40000000L / (long)this.pageSize) {
            ++n;
        }
        if (n > this.mxPgno) {
            this.mxPgno = n;
        }
        return n;
    }

    private void error(SqlJetException e) {
        SqlJetErrorCode c = e.getErrorCode();
        if (SqlJetErrorCode.FULL == c || SqlJetErrorCode.IOERR == c || SqlJetErrorCode.CORRUPT == c) {
            this.errCode = c;
            if (SqlJetPagerState.UNLOCK == this.state && this.pageCache.getRefCount() == 0) {
                this.unlock();
            }
        }
    }

    private void releaseAllSavepoint() {
        for (int ii = 0; ii < this.nSavepoint; ++ii) {
            this.aSavepoint[ii].pInSavepoint = null;
        }
        if (!this.exclusiveMode() && this.sjfd != null) {
            try {
                this.sjfd.close();
            }
            catch (SqlJetException sqlJetException) {
                // empty catch block
            }
        }
        this.aSavepoint = null;
        this.nSavepoint = 0;
        this.stmtNRec = 0;
    }

    void addToSavepointBitSets(int pgno) {
        for (int ii = 0; ii < this.nSavepoint; ++ii) {
            PagerSavepoint p = this.aSavepoint[ii];
            if (pgno > p.nOrig) continue;
            p.pInSavepoint.set(pgno);
        }
    }

    private void unlock() {
        if (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode) {
            if (this.journalOpen) {
                if (null != this.jfd) {
                    try {
                        this.jfd.close();
                    }
                    catch (SqlJetException e) {
                        // empty catch block
                    }
                }
                this.journalOpen = false;
                this.pagesInJournal = null;
                this.pagesAlwaysRollback = null;
            }
            try {
                if (null != this.fd) {
                    this.fd.unlock(SqlJetLockType.NONE);
                }
            }
            catch (SqlJetException e) {
                this.errCode = e.getErrorCode();
            }
            this.dbSizeValid = false;
            SqlJetPager.PAGERTRACE("UNLOCK %s\n", this.PAGERID());
            if (null != this.errCode) {
                this.errCode = null;
                this.reset();
                this.releaseAllSavepoint();
                this.journalOff = 0L;
                this.journalStarted = false;
                this.dbOrigSize = 0;
            }
            this.state = SqlJetPagerState.UNLOCK;
            this.changeCountDone = false;
        }
    }

    @Override
    public void close() throws SqlJetException {
        this.errCode = null;
        this.lockingMode = SqlJetPagerLockingMode.NORMAL;
        this.reset();
        if (!this.memDb) {
            this.journalHdr = -1L;
            this.unlockAndRollback();
        }
        SqlJetPager.PAGERTRACE("CLOSE %s\n", this.PAGERID());
        if (this.journalOpen && null != this.jfd) {
            this.jfd.close();
        }
        this.pagesInJournal = null;
        this.pagesAlwaysRollback = null;
        this.releaseAllSavepoint();
        if (null != this.fd) {
            this.fd.close();
        }
        this.tmpSpace = null;
        if (this.pageCache != null) {
            this.pageCache.close();
        }
    }

    @Override
    public ISqlJetPage acquirePage(int pageNumber, boolean read) throws SqlJetException {
        assert (this.state == SqlJetPagerState.UNLOCK || this.pageCache.getRefCount() > 0 || pageNumber == 1);
        if (pageNumber > Integer.MAX_VALUE || pageNumber == 0 || (long)pageNumber == 0x40000000L / (long)this.pageSize + 1L) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.sharedLock();
        assert (this.state != SqlJetPagerState.UNLOCK);
        ISqlJetPage page = this.pageCache.fetch(pageNumber, true);
        if (null == page) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL, "Page cache is overflow");
        }
        if (null == page.getPager()) {
            block19: {
                int nMax;
                page.setPager(this);
                try {
                    nMax = this.getPageCount();
                }
                catch (SqlJetException e) {
                    page.unref();
                    throw e;
                }
                if (nMax < pageNumber || this.memDb || !read) {
                    if (pageNumber > this.mxPgno) {
                        page.unref();
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                    SqlJetUtility.memset(page.getData(), (byte)0, this.pageSize);
                    if (!read) {
                        if (null == page.getFlags()) {
                            page.setFlags(SqlJetUtility.noneOf(SqlJetPageFlags.class));
                        }
                        page.getFlags().add(SqlJetPageFlags.NEED_READ);
                    }
                    SqlJetPager.PAGERTRACE("ZERO %s %d\n", this.PAGERID(), pageNumber);
                } else {
                    try {
                        this.readDbPage(page, pageNumber);
                    }
                    catch (SqlJetIOException e) {
                        if (SqlJetIOErrorCode.IOERR_SHORT_READ == e.getIoErrorCode()) break block19;
                        this.dropPage(page);
                        throw e;
                    }
                }
            }
            page.setHash(this.pageHash(page));
        } else {
            assert (this.pageCache.getRefCount() > 0 || 1 == pageNumber);
            if (read) {
                try {
                    this.getContent(page);
                }
                catch (SqlJetException e) {
                    page.unref();
                    throw e;
                }
            }
        }
        return page;
    }

    void getContent(ISqlJetPage page) throws SqlJetIOException {
        Set<SqlJetPageFlags> flags = page.getFlags();
        if (null != flags && flags.contains((Object)SqlJetPageFlags.NEED_READ)) {
            this.readDbPage(page, page.getPageNumber());
            flags.remove((Object)SqlJetPageFlags.NEED_READ);
        }
    }

    long pageHash(ISqlJetPage page) {
        return this.dataHash(this.pageSize, page.getData());
    }

    private long dataHash(int numByte, ByteBuffer data) {
        long hash = 0L;
        return hash;
    }

    private void dropPage(ISqlJetPage page) throws SqlJetException {
        this.pageCache.drop(page);
        this.unlockIfUnused();
    }

    void unlockIfUnused() throws SqlJetException {
        if (this.pageCache.getRefCount() == 0 && (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode || this.journalOff > 0L)) {
            this.unlockAndRollback();
        }
    }

    private void unlockAndRollback() throws SqlJetException {
        if (this.errCode == null && SqlJetPagerState.RESERVED.compareTo(this.state) <= 0) {
            this.rollback();
        }
        this.unlock();
    }

    private void readDbPage(ISqlJetPage page, int pageNumber) throws SqlJetIOException {
        assert (!this.memDb);
        assert (null != this.fd || this.tempFile);
        if (null == this.fd) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_SHORT_READ);
        }
        long offset = (pageNumber - 1) * this.pageSize;
        ByteBuffer data = page.getData();
        this.fd.read(data, this.pageSize, offset);
        if (1 == pageNumber) {
            SqlJetUtility.memcpy(this.dbFileVers, 0, data, 24, this.dbFileVers.remaining());
        }
        SqlJetPager.PAGERTRACE("FETCH %s page %d hash(%08x)\n", this.PAGERID(), page.getPageNumber(), this.pageHash(page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sharedLock() throws SqlJetException {
        boolean isErrorReset = false;
        if (!this.memDb && this.lockingMode == SqlJetPagerLockingMode.EXCLUSIVE && this.pageCache.getRefCount() == 0 && null != this.errCode) {
            if (this.journalOpen) {
                isErrorReset = true;
            }
            this.errCode = null;
            this.reset();
        }
        if (null != this.errCode && this.errCode != SqlJetErrorCode.FULL) {
            throw new SqlJetException(this.errCode);
        }
        if (SqlJetPagerState.UNLOCK == this.state || isErrorReset) {
            try {
                boolean isHotJournal = false;
                assert (!this.memDb);
                assert (this.pageCache.getRefCount() == 0);
                if (!this.noReadlock) {
                    try {
                        this.waitOnLock(SqlJetLockType.SHARED);
                    }
                    catch (SqlJetException e) {
                        assert (this.state == SqlJetPagerState.UNLOCK);
                        this.error(e);
                        throw e;
                    }
                } else if (this.state == SqlJetPagerState.UNLOCK) {
                    this.state = SqlJetPagerState.SHARED;
                }
                assert (SqlJetPagerState.SHARED == this.state);
                if (!isErrorReset) {
                    isHotJournal = this.hasHotJournal();
                }
                if (isErrorReset || isHotJournal) {
                    if (SqlJetPagerState.EXCLUSIVE.compareTo(this.state) > 0) {
                        try {
                            this.fd.lock(SqlJetLockType.EXCLUSIVE);
                        }
                        catch (SqlJetException e) {
                            this.error(e);
                            throw e;
                        }
                        this.state = SqlJetPagerState.EXCLUSIVE;
                    }
                    if (!isErrorReset && !this.journalOpen) {
                        if (this.fileSystem.access(this.journal, SqlJetFileAccesPermission.EXISTS)) {
                            assert (!this.tempFile);
                            this.jfd = this.fileSystem.open(this.journal, SqlJetFileType.MAIN_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE));
                            if (null != this.jfd) {
                                try {
                                    Set<SqlJetFileOpenPermission> p = this.jfd.getPermissions();
                                    if (p.contains((Object)SqlJetFileOpenPermission.READONLY)) {
                                        throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
                                    }
                                }
                                catch (SqlJetException e) {
                                    this.jfd.close();
                                    throw e;
                                }
                            }
                        } else {
                            throw new SqlJetException(SqlJetErrorCode.BUSY);
                        }
                        this.journalOpen = true;
                        this.journalStarted = false;
                        this.journalOff = 0L;
                        this.setMaster = false;
                        this.journalHdr = 0L;
                        try {
                            this.pageCache.clear();
                        }
                        finally {
                            try {
                                this.playback(true);
                            }
                            catch (SqlJetException e) {
                                this.error(e);
                                throw e;
                            }
                        }
                        assert (SqlJetPagerState.SHARED == this.state || SqlJetPagerLockingMode.EXCLUSIVE == this.lockingMode && SqlJetPagerState.SHARED.compareTo(this.state) < 0);
                    }
                }
                if (this.pageCache.getPageCount() > 0) {
                    ByteBuffer dbFileVers = ByteBuffer.allocate(this.dbFileVers.remaining());
                    this.getPageCount();
                    if (null != this.errCode) {
                        throw new SqlJetException(this.errCode);
                    }
                    assert (this.dbSizeValid);
                    if (this.dbSize > 0) {
                        SqlJetPager.PAGERTRACE("CKVERS %s %d\n", this.PAGERID(), dbFileVers.remaining());
                        this.fd.read(dbFileVers, dbFileVers.remaining(), 24L);
                    } else {
                        SqlJetUtility.memset(dbFileVers, (byte)0, dbFileVers.remaining());
                    }
                    if (SqlJetUtility.memcmp(this.dbFileVers, dbFileVers, dbFileVers.remaining()) != 0) {
                        this.reset();
                    }
                }
                assert (SqlJetPagerLockingMode.EXCLUSIVE == this.lockingMode || SqlJetPagerState.SHARED == this.state);
            }
            catch (SqlJetException e) {
                this.unlock();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void playback(boolean isHot) throws SqlJetException {
        block54: {
            block59: {
                block58: {
                    block48: {
                        block57: {
                            block46: {
                                block47: {
                                    rc = null;
                                    nRec = -1;
                                    mxPg = 0;
                                    res = true;
                                    zMaster = null;
                                    if (!SqlJetPager.$assertionsDisabled && !this.journalOpen) {
                                        throw new AssertionError();
                                    }
                                    try {
                                        try {
                                            szJ = this.jfd.fileSize();
                                            if (szJ == 0L) {
                                                var12_8 = null;
                                                if (rc != null) break block46;
                                                break block47;
                                            }
                                            zMaster = this.readMasterJournal(this.jfd);
                                            if (null != zMaster) {
                                                res = this.fileSystem.access(new File(zMaster), SqlJetFileAccesPermission.EXISTS);
                                            }
                                            if (!res) {
                                                break block48;
                                            }
                                            this.journalOff = 0L;
                                            block26: while (true) {
                                                block49: {
                                                    try {
                                                        readJournalHdr = this.readJournalHdr(szJ);
                                                        nRec = readJournalHdr[0];
                                                        mxPg = readJournalHdr[1];
                                                    }
                                                    catch (SqlJetException e) {
                                                        if (SqlJetErrorCode.DONE != e.getErrorCode()) break block49;
                                                        var12_10 = null;
                                                        if (rc == null) {
                                                            try {
                                                                zMaster = this.readMasterJournal(this.jfd);
                                                            }
                                                            catch (SqlJetException e) {
                                                                rc = e;
                                                            }
                                                        }
                                                        if (rc == null) {
                                                            try {
                                                                this.endTransaction(zMaster != null);
                                                            }
                                                            catch (SqlJetException e) {
                                                                rc = e;
                                                            }
                                                        }
                                                        if (rc != null) return;
                                                        if (zMaster == null) return;
                                                        if (res == false) return;
                                                        try {
                                                            this.deleteMaster(zMaster);
                                                            return;
                                                        }
                                                        catch (SqlJetException e) {
                                                            rc = e;
                                                        }
                                                        return;
                                                    }
                                                }
                                                if (nRec == -1) {
                                                    if (!SqlJetPager.$assertionsDisabled && this.journalOff != (long)this.JOURNAL_HDR_SZ()) {
                                                        throw new AssertionError();
                                                    }
                                                    nRec = (int)((szJ - (long)this.JOURNAL_HDR_SZ()) / (long)this.JOURNAL_PG_SZ());
                                                }
                                                if (nRec == 0 && !isHot && this.journalHdr + (long)this.JOURNAL_HDR_SZ() == this.journalOff) {
                                                    nRec = (int)((szJ - this.journalOff) / (long)this.JOURNAL_PG_SZ());
                                                }
                                                if (this.journalOff == (long)this.JOURNAL_HDR_SZ()) {
                                                    this.doTruncate(mxPg);
                                                    this.dbSize = mxPg;
                                                }
                                                u = 0;
                                                while (true) {
                                                    if (u >= nRec) continue block26;
                                                    try {
                                                        this.playbackOnePage(true, this.journalOff, false, null);
                                                    }
                                                    catch (SqlJetException e) {
                                                        if (e.getErrorCode() != SqlJetErrorCode.DONE) throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                                                        this.journalOff = szJ;
                                                        continue block26;
                                                    }
                                                    ++u;
                                                }
                                                break;
                                            }
                                        }
                                        catch (SqlJetException e) {
                                            block53: {
                                                block52: {
                                                    rc = e;
                                                    var12_11 = null;
                                                    if (rc == null) {
                                                        ** try [egrp 4[TRYBLOCK] [11 : 350->363)] { 
lbl84:
                                                        // 1 sources

                                                        zMaster = this.readMasterJournal(this.jfd);
                                                        break block52;
lbl86:
                                                        // 1 sources

                                                        catch (SqlJetException e) {
                                                            rc = e;
                                                        }
                                                    }
                                                }
                                                if (rc == null) {
                                                    ** try [egrp 5[TRYBLOCK] [12 : 372->389)] { 
lbl91:
                                                    // 1 sources

                                                    this.endTransaction(zMaster != null);
                                                    break block53;
lbl93:
                                                    // 1 sources

                                                    catch (SqlJetException e) {
                                                        rc = e;
                                                    }
                                                }
                                            }
                                            if (rc == null && zMaster != null && res) {
                                                ** try [egrp 6[TRYBLOCK] [13 : 408->417)] { 
lbl98:
                                                // 1 sources

                                                this.deleteMaster(zMaster);
lbl100:
                                                // 1 sources

                                                catch (SqlJetException e) {
                                                    rc = e;
                                                }
                                            }
                                            break block54;
                                        }
                                    }
                                    catch (Throwable var11_23) {
                                        block56: {
                                            block55: {
                                                var12_12 = null;
                                                if (rc == null) {
                                                    ** try [egrp 4[TRYBLOCK] [11 : 350->363)] { 
lbl108:
                                                    // 1 sources

                                                    zMaster = this.readMasterJournal(this.jfd);
                                                    break block55;
lbl110:
                                                    // 1 sources

                                                    catch (SqlJetException e) {
                                                        rc = e;
                                                    }
                                                }
                                            }
                                            if (rc == null) {
                                                ** try [egrp 5[TRYBLOCK] [12 : 372->389)] { 
lbl115:
                                                // 1 sources

                                                this.endTransaction(zMaster != null);
                                                break block56;
lbl117:
                                                // 1 sources

                                                catch (SqlJetException e) {
                                                    rc = e;
                                                }
                                            }
                                        }
                                        if (rc != null) throw var11_23;
                                        if (zMaster == null) throw var11_23;
                                        if (res == false) throw var11_23;
                                        ** try [egrp 6[TRYBLOCK] [13 : 408->417)] { 
lbl124:
                                        // 1 sources

                                        this.deleteMaster(zMaster);
                                        throw var11_23;
lbl126:
                                        // 1 sources

                                        catch (SqlJetException e) {
                                            rc = e;
                                        }
                                        throw var11_23;
                                    }
                                }
                                ** try [egrp 4[TRYBLOCK] [11 : 350->363)] { 
lbl131:
                                // 1 sources

                                zMaster = this.readMasterJournal(this.jfd);
                                break block46;
lbl133:
                                // 1 sources

                                catch (SqlJetException e) {
                                    rc = e;
                                }
                            }
                            if (rc == null) {
                                ** try [egrp 5[TRYBLOCK] [12 : 372->389)] { 
lbl138:
                                // 1 sources

                                this.endTransaction(zMaster != null);
                                break block57;
lbl140:
                                // 1 sources

                                catch (SqlJetException e) {
                                    rc = e;
                                }
                            }
                        }
                        if (rc != null) return;
                        if (zMaster == null) return;
                        if (res == false) return;
                        ** try [egrp 6[TRYBLOCK] [13 : 408->417)] { 
lbl147:
                        // 1 sources

                        this.deleteMaster(zMaster);
                        return;
lbl149:
                        // 1 sources

                        catch (SqlJetException e) {
                            rc = e;
                        }
                        return;
                    }
                    var12_9 = null;
                    if (rc == null) {
                        ** try [egrp 4[TRYBLOCK] [11 : 350->363)] { 
lbl156:
                        // 1 sources

                        zMaster = this.readMasterJournal(this.jfd);
                        break block58;
lbl158:
                        // 1 sources

                        catch (SqlJetException e) {
                            rc = e;
                        }
                    }
                }
                if (rc == null) {
                    ** try [egrp 5[TRYBLOCK] [12 : 372->389)] { 
lbl163:
                    // 1 sources

                    this.endTransaction(zMaster != null);
                    break block59;
lbl165:
                    // 1 sources

                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
            }
            if (rc != null) return;
            if (zMaster == null) return;
            if (res == false) return;
            ** try [egrp 6[TRYBLOCK] [13 : 408->417)] { 
lbl172:
            // 1 sources

            this.deleteMaster(zMaster);
            return;
lbl174:
            // 1 sources

            catch (SqlJetException e) {
                rc = e;
            }
            return;
        }
        this.setSectorSize();
        if (rc == null) return;
        throw rc;
    }

    private void playbackSavepoint(PagerSavepoint pSavepoint) throws SqlJetException {
        int ii;
        SqlJetException rc = null;
        BitSet pDone = null;
        if (pSavepoint != null) {
            pDone = new BitSet(pSavepoint.nOrig);
        }
        int n = this.dbSize = pSavepoint != null ? pSavepoint.nOrig : this.dbOrigSize;
        assert (this.state.compareTo(SqlJetPagerState.SHARED) >= 0);
        long szJ = this.journalOff;
        if (pSavepoint != null) {
            long iHdrOff = pSavepoint.iHdrOffset > 0L ? pSavepoint.iHdrOffset : szJ;
            this.journalOff = pSavepoint.iOffset;
            while (rc == null && this.journalOff < iHdrOff) {
                try {
                    this.playbackOnePage(true, this.journalOff, true, pDone);
                }
                catch (SqlJetException e) {
                    rc = e;
                    assert (e.getErrorCode() != SqlJetErrorCode.DONE);
                }
            }
        } else {
            this.journalOff = 0L;
        }
        while (rc == null && this.journalOff < szJ) {
            long nJRec;
            block25: {
                nJRec = 0L;
                try {
                    int[] b = this.readJournalHdr(szJ);
                    nJRec = b[0];
                }
                catch (SqlJetException e) {
                    rc = e;
                    if ($assertionsDisabled || e.getErrorCode() != SqlJetErrorCode.DONE) break block25;
                    throw new AssertionError();
                }
            }
            assert (nJRec != 0L || this.journalHdr + (long)this.JOURNAL_HDR_SZ() == this.journalOff || (szJ - this.journalOff) / (long)this.JOURNAL_PG_SZ() <= 0L);
            if (nJRec == 0L && this.journalHdr + (long)this.JOURNAL_HDR_SZ() == this.journalOff) {
                nJRec = (szJ - this.journalOff) / (long)this.JOURNAL_PG_SZ();
            }
            ii = 0;
            while (rc == null && (long)ii < nJRec && this.journalOff < szJ) {
                block26: {
                    try {
                        this.playbackOnePage(true, this.journalOff, true, pDone);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                        if ($assertionsDisabled || e.getErrorCode() != SqlJetErrorCode.DONE) break block26;
                        throw new AssertionError();
                    }
                }
                ++ii;
            }
        }
        assert (rc != null || this.journalOff == szJ);
        if (pSavepoint != null) {
            long offset = pSavepoint.iSubRec * (4 + this.pageSize);
            for (ii = pSavepoint.iSubRec; rc == null && ii < this.stmtNRec; ++ii) {
                assert (offset == (long)(ii * (4 + this.pageSize)));
                try {
                    this.playbackOnePage(false, offset, true, pDone);
                    continue;
                }
                catch (SqlJetException e) {
                    rc = e;
                    assert (e.getErrorCode() != SqlJetErrorCode.DONE);
                    continue;
                }
            }
        }
        pDone = null;
        if (rc == null) {
            this.journalOff = szJ;
        }
        if (rc != null) {
            throw rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMaster(String master) throws SqlJetException {
        boolean master_open = false;
        ISqlJetFile pMaster = null;
        ByteBuffer zMasterJournal = null;
        try {
            pMaster = this.fileSystem.open(new File(master), SqlJetFileType.MASTER_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
            master_open = true;
            int nMasterJournal = Long.valueOf(pMaster.fileSize()).intValue();
            if (nMasterJournal > 0) {
                int zMasterPtr;
                zMasterJournal = ByteBuffer.allocate(nMasterJournal);
                pMaster.read(zMasterJournal, nMasterJournal, 0L);
                for (int nMasterPtr = 0; nMasterPtr < nMasterJournal; nMasterPtr += zMasterPtr + 1) {
                    zMasterPtr = SqlJetUtility.strlen(zMasterJournal, nMasterPtr);
                    String zJournal = new String(zMasterJournal.array(), nMasterPtr, zMasterPtr);
                    File journalPath = new File(zJournal);
                    boolean exists = this.fileSystem.access(journalPath, SqlJetFileAccesPermission.EXISTS);
                    if (!exists) continue;
                    ISqlJetFile pJournal = this.fileSystem.open(journalPath, SqlJetFileType.MAIN_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
                    try {
                        String readJournal = this.readMasterJournal(pJournal);
                        if (readJournal == null || !readJournal.equals(master)) continue;
                        return;
                    }
                    finally {
                        pJournal.close();
                    }
                }
            }
            this.fileSystem.delete(new File(master), false);
        }
        finally {
            if (master_open && pMaster != null) {
                pMaster.close();
            }
        }
    }

    private void endTransaction(boolean hasMaster) throws SqlJetException {
        SqlJetException rc = null;
        SqlJetException rc2 = null;
        if (this.state.compareTo(SqlJetPagerState.RESERVED) < 0) {
            return;
        }
        this.releaseAllSavepoint();
        if (this.journalOpen) {
            if (this.journalMode == SqlJetPagerJournalMode.MEMORY) {
                boolean isMemoryJournal = this.jfd.isMemJournal();
                try {
                    this.jfd.close();
                }
                catch (SqlJetException e) {
                    // empty catch block
                }
                this.journalOpen = false;
                if (!isMemoryJournal) {
                    try {
                        this.fileSystem.delete(this.journal, false);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
            } else if (this.journalMode == SqlJetPagerJournalMode.TRUNCATE) {
                try {
                    this.jfd.truncate(0L);
                    this.journalOff = 0L;
                    this.journalStarted = false;
                }
                catch (SqlJetException e) {
                    rc = e;
                    try {
                        this.jfd.close();
                    }
                    catch (SqlJetException e1) {
                        // empty catch block
                    }
                    this.journalOpen = false;
                }
            } else if (this.exclusiveMode() || this.journalMode == SqlJetPagerJournalMode.PERSIST) {
                try {
                    this.zeroJournalHdr(hasMaster);
                }
                catch (SqlJetException e) {
                    rc = e;
                }
                if (rc != null) {
                    this.error(rc);
                }
                this.journalOff = 0L;
                this.journalStarted = false;
            } else {
                assert (this.journalMode == SqlJetPagerJournalMode.DELETE);
                try {
                    this.jfd.close();
                }
                catch (SqlJetException e) {
                    // empty catch block
                }
                this.journalOpen = false;
                if (rc == null && !this.tempFile) {
                    try {
                        this.fileSystem.delete(this.journal, false);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
            }
            this.pagesInJournal = null;
            this.pagesAlwaysRollback = null;
            this.pageCache.cleanAll();
            this.dirtyCache = false;
            this.nRec = 0;
        } else assert (null == this.pagesInJournal);
        if (!this.exclusiveMode()) {
            if (null != this.fd) {
                try {
                    this.fd.unlock(SqlJetLockType.SHARED);
                }
                catch (SqlJetException e) {
                    rc2 = e;
                }
            }
            this.state = SqlJetPagerState.SHARED;
            this.changeCountDone = false;
        } else if (this.state == SqlJetPagerState.SYNCED) {
            this.state = SqlJetPagerState.EXCLUSIVE;
        }
        this.dbOrigSize = 0;
        this.setMaster = false;
        this.needSync = false;
        this.pageCache.truncate(this.dbSize);
        if (!this.memDb) {
            this.dbSizeValid = false;
        }
        this.dbModified = false;
        if (rc != null) {
            throw rc;
        }
        if (rc2 != null) {
            throw rc2;
        }
    }

    private void zeroJournalHdr(boolean doTruncate) throws SqlJetException {
        SqlJetException rc = null;
        ByteBuffer zeroHdr = ByteBuffer.allocate(28);
        if (this.journalOff > 0L) {
            long iLimit = this.journalSizeLimit;
            if (doTruncate || iLimit == 0L) {
                try {
                    this.jfd.truncate(0L);
                }
                catch (SqlJetException e) {
                    rc = e;
                }
            } else {
                try {
                    this.jfd.write(zeroHdr, zeroHdr.remaining(), 0L);
                }
                catch (SqlJetException e) {
                    rc = e;
                }
            }
            if (rc == null && !this.noSync) {
                this.jfd.sync(this.syncFlags);
            }
            if (rc == null && iLimit > 0L) {
                long sz = 0L;
                try {
                    sz = this.jfd.fileSize();
                }
                catch (SqlJetException e) {
                    rc = e;
                }
                if (rc == null && sz > iLimit) {
                    try {
                        this.jfd.truncate(iLimit);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
            }
        }
        if (null != rc) {
            throw rc;
        }
    }

    private boolean exclusiveMode() {
        return this.lockingMode == SqlJetPagerLockingMode.EXCLUSIVE;
    }

    private void playbackOnePage(boolean isMainJrnl, long pOffset, boolean isSavepnt, BitSet pDone) throws SqlJetException {
        assert (isMainJrnl || pDone != null);
        assert (isSavepnt || pDone == null);
        ByteBuffer aData = this.tmpSpace;
        assert (aData != null);
        ISqlJetFile jfd = isMainJrnl ? this.jfd : this.sjfd;
        int pgno = this.read32bits(jfd, pOffset);
        jfd.read(aData, this.pageSize, pOffset + 4L);
        pOffset += (long)(this.pageSize + 4 + (isMainJrnl ? 4 : 0));
        if (pgno == 0 || (long)pgno == this.PAGER_MJ_PGNO()) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        if (pgno > this.dbSize || SqlJetUtility.bitSetTest(pDone, pgno)) {
            return;
        }
        if (isMainJrnl) {
            long cksum = this.read32bitsUnsigned(jfd, pOffset - 4L);
            if (!isSavepnt && this.cksum(aData) != cksum) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
        }
        if (pDone != null) {
            pDone.set(pgno);
        }
        assert (this.state == SqlJetPagerState.RESERVED || this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0);
        ISqlJetPage pPg = this.lookup(pgno);
        SqlJetPager.PAGERTRACE("PLAYBACK %s page %d hash(%08x) %s\n", this.PAGERID(), pgno, this.dataHash(this.pageSize, aData), isMainJrnl ? "main-journal" : "sub-journal");
        if (!(this.state.compareTo(SqlJetPagerState.EXCLUSIVE) < 0 || pPg != null && pPg.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC) || null == this.fd)) {
            long ofst = (pgno - 1) * this.pageSize;
            this.fd.write(aData, this.pageSize, ofst);
            if (pgno > this.dbFileSize) {
                this.dbFileSize = pgno;
            }
        } else if (!isMainJrnl && pPg == null) {
            assert (isSavepnt);
            pPg = this.acquirePage(pgno, true);
            pPg.getFlags().remove((Object)SqlJetPageFlags.NEED_READ);
            this.pageCache.makeDirty(pPg);
        }
        if (null != pPg) {
            ByteBuffer pData = pPg.getData();
            SqlJetUtility.memcpy(pData, aData, this.pageSize);
            if (null != this.reiniter) {
                this.reiniter.pageCallback(pPg);
            }
            if (isMainJrnl && (!isSavepnt || this.journalOff <= this.journalHdr)) {
                this.pageCache.makeClean(pPg);
            }
            pPg.setHash(this.pageHash(pPg));
            if (pgno == 1) {
                SqlJetUtility.memcpy(this.dbFileVers, 0, pData, 24, this.dbFileVers.remaining());
            }
            this.pageCache.release(pPg);
        }
    }

    long cksum(ByteBuffer data) {
        long cksum = this.cksumInit;
        for (int i = this.pageSize - 200; i > 0; i -= 200) {
            cksum += (long)SqlJetUtility.getUnsignedByte(data, i);
        }
        return cksum;
    }

    private String readMasterJournal(ISqlJetFile journal) throws SqlJetException {
        ByteBuffer aMagic = ByteBuffer.allocate(8);
        long szJ = journal.fileSize();
        if (szJ < 16L) {
            return null;
        }
        int len = this.read32bits(journal, szJ - 16L);
        long cksum = this.read32bitsUnsigned(journal, szJ - 12L);
        journal.read(aMagic, aMagic.remaining(), szJ - 8L);
        if (0 != SqlJetUtility.memcmp(aMagic, aJournalMagic, aMagic.remaining())) {
            return null;
        }
        ByteBuffer zMaster = ByteBuffer.allocate(len);
        journal.read(zMaster, len, szJ - 16L - (long)len);
        for (int u = 0; u < len; ++u) {
            cksum -= (long)SqlJetUtility.getUnsignedByte(zMaster, u);
        }
        if (cksum > 0L) {
            return null;
        }
        return new String(zMaster.array());
    }

    private int read32bits(ISqlJetFile fd, long offset) throws SqlJetIOException {
        ByteBuffer ac = ByteBuffer.allocate(4);
        fd.read(ac, ac.remaining(), offset);
        return SqlJetUtility.get4byte(ac);
    }

    private long read32bitsUnsigned(ISqlJetFile fd, long offset) throws SqlJetIOException {
        ByteBuffer ac = ByteBuffer.allocate(4);
        fd.read(ac, ac.remaining(), offset);
        return SqlJetUtility.get4byteUnsigned(ac);
    }

    private int[] readJournalHdr(long journalSize) throws SqlJetException {
        int[] result = new int[2];
        ByteBuffer aMagic = ByteBuffer.allocate(8);
        this.seekJournalHdr();
        if (this.journalOff + (long)this.JOURNAL_HDR_SZ() > journalSize) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        long jrnlOff = this.journalOff;
        this.jfd.read(aMagic, aMagic.remaining(), jrnlOff);
        jrnlOff += (long)aMagic.remaining();
        if (0 != SqlJetUtility.memcmp(aMagic, aJournalMagic, aMagic.remaining())) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        int pNRec = this.read32bits(this.jfd, jrnlOff);
        this.cksumInit = this.read32bitsUnsigned(this.jfd, jrnlOff + 4L);
        int pDbSize = this.read32bits(this.jfd, jrnlOff + 8L);
        result[0] = pNRec;
        result[1] = pDbSize;
        if (this.journalOff == 0L) {
            int iPageSize = this.read32bits(this.jfd, jrnlOff + 16L);
            if (iPageSize < 512 || iPageSize > 32768 || (iPageSize - 1 & iPageSize) != 0) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.setPageSize(iPageSize);
            assert (this.pageSize == iPageSize);
            int iSectorSize = this.read32bits(this.jfd, jrnlOff + 12L);
            if ((iSectorSize & iSectorSize - 1) != 0 || iSectorSize < 512 || iSectorSize > 32768) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.sectorSize = iSectorSize;
        }
        this.journalOff += (long)this.JOURNAL_HDR_SZ();
        return result;
    }

    private long journalHdrOffset() {
        long offset = 0L;
        long c = this.journalOff;
        if (c > 0L) {
            offset = ((c - 1L) / (long)this.JOURNAL_HDR_SZ() + 1L) * (long)this.JOURNAL_HDR_SZ();
        }
        assert (offset % (long)this.JOURNAL_HDR_SZ() == 0L);
        assert (offset >= c);
        assert (offset - c < (long)this.JOURNAL_HDR_SZ());
        return offset;
    }

    private void seekJournalHdr() {
        this.journalOff = this.journalHdrOffset();
    }

    private boolean hasHotJournal() throws SqlJetException {
        boolean exists = false;
        boolean locked = false;
        assert (this.useJournal);
        assert (null != this.fd);
        exists = this.fileSystem.access(this.journal, SqlJetFileAccesPermission.EXISTS);
        if (exists) {
            locked = this.fd.checkReservedLock();
        }
        if (exists && !locked) {
            if (0 == this.getPageCount()) {
                this.fileSystem.delete(this.journal, false);
            } else {
                return true;
            }
        }
        return false;
    }

    private void waitOnLock(SqlJetLockType lockType) throws SqlJetException {
        assert (SqlJetPagerState.SHARED.compareTo(this.state) <= 0 || !this.dbSizeValid);
        if (this.state.getLockType().compareTo(lockType) < 0) {
            boolean lock = false;
            int n = 0;
            while (((lock = this.fd.lock(lockType)) || null == this.busyHandler || this.busyHandler.call(n++)) && !lock) {
            }
            if (lock) {
                this.state = SqlJetPagerState.getPagerState(lockType);
            } else {
                throw new SqlJetException(SqlJetErrorCode.BUSY);
            }
        }
    }

    @Override
    public ISqlJetPage getPage(int pageNumber) throws SqlJetException {
        return this.acquirePage(pageNumber, true);
    }

    @Override
    public ISqlJetPage lookupPage(int pageNumber) throws SqlJetException {
        assert (pageNumber != 0);
        if (this.state != SqlJetPagerState.UNLOCK && (this.errCode == null || this.errCode == SqlJetErrorCode.FULL)) {
            return this.pageCache.fetch(pageNumber, false);
        }
        return null;
    }

    @Override
    public void truncateImage(int pagesNumber) {
        assert (this.dbSizeValid);
        assert (this.dbSize >= pagesNumber);
        this.dbSize = pagesNumber;
    }

    @Override
    public int imageSize() {
        assert (this.dbSizeValid);
        return this.dbSize;
    }

    private void doTruncate(int pageNumber) throws SqlJetException {
        long newSize;
        long currentSize;
        if (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0 && null != this.fd && (currentSize = this.fd.fileSize()) != (newSize = (long)(this.pageSize * pageNumber))) {
            if (currentSize > newSize) {
                this.fd.truncate(newSize);
            } else {
                ByteBuffer b = ByteBuffer.allocate(1);
                this.fd.write(b, 1, newSize - 1L);
            }
            this.dbFileSize = this.nPage;
        }
    }

    private void syncJournal() throws SqlJetIOException {
        if (this.needSync) {
            assert (!this.tempFile);
            if (this.journalMode != SqlJetPagerJournalMode.MEMORY) {
                assert (this.journalOpen);
                Set<SqlJetDeviceCharacteristics> dc = this.fd.deviceCharacteristics();
                if (!dc.contains((Object)SqlJetDeviceCharacteristics.IOCAP_SAFE_APPEND)) {
                    long jrnlOff;
                    block10: {
                        jrnlOff = this.journalHdrOffset();
                        ByteBuffer zMagic = ByteBuffer.allocate(8);
                        try {
                            this.jfd.read(zMagic, 8, jrnlOff);
                            if (0 == SqlJetUtility.memcmp(zMagic, aJournalMagic, 8)) {
                                ByteBuffer zerobyte = ByteBuffer.allocate(1);
                                this.jfd.write(zerobyte, 1, jrnlOff);
                            }
                        }
                        catch (SqlJetIOException e) {
                            if (e.getIoErrorCode() == SqlJetIOErrorCode.IOERR_SHORT_READ) break block10;
                            throw e;
                        }
                    }
                    if (this.fullSync && !dc.contains((Object)SqlJetDeviceCharacteristics.IOCAP_SEQUENTIAL)) {
                        SqlJetPager.PAGERTRACE("SYNC journal of %s\n", this.PAGERID());
                        this.jfd.sync(this.syncFlags);
                    }
                    jrnlOff = this.journalHdr + (long)aJournalMagic.remaining();
                    SqlJetPager.PAGERTRACE("JHDR %s %d %d\n", this.PAGERID(), jrnlOff, 4);
                    SqlJetPager.write32bits(this.jfd, jrnlOff, this.nRec);
                }
                if (!dc.contains((Object)SqlJetDeviceCharacteristics.IOCAP_SEQUENTIAL)) {
                    SqlJetPager.PAGERTRACE("SYNC journal of %s\n", this.PAGERID());
                    this.jfd.sync(this.syncFlags);
                }
                this.journalStarted = true;
            }
            this.needSync = false;
            this.pageCache.clearSyncFlags();
        }
    }

    void subjournalPage(SqlJetPage pPg) throws SqlJetIOException {
        ByteBuffer pData = pPg.getData();
        long offset = this.stmtNRec * (4 + this.pageSize);
        SqlJetPager.PAGERTRACE("STMT-JOURNAL %s page %d\n", this.PAGERID(), pPg.pgno);
        assert (SqlJetPager.pageInJournal(pPg) || pPg.pgno > this.dbOrigSize);
        SqlJetPager.write32bits(this.sjfd, offset, pPg.pgno);
        this.sjfd.write(pData, this.pageSize, offset + 4L);
        ++this.stmtNRec;
        assert (this.nSavepoint > 0);
        this.addToSavepointBitSets(pPg.pgno);
    }

    static void write32bits(ISqlJetFile fd, long offset, int val) throws SqlJetIOException {
        ByteBuffer b = SqlJetUtility.put4byte(val);
        fd.write(b, b.remaining(), offset);
    }

    static void write32bitsUnsigned(ISqlJetFile fd, long offset, long val) throws SqlJetIOException {
        ByteBuffer b = SqlJetUtility.put4byteUnsigned(val);
        fd.write(b, b.remaining(), offset);
    }

    @Override
    public void begin(boolean exclusive) throws SqlJetException {
        assert (this.state != SqlJetPagerState.UNLOCK);
        if (this.state == SqlJetPagerState.SHARED) {
            assert (this.pagesInJournal == null);
            assert (!this.memDb);
            this.fd.lock(SqlJetLockType.RESERVED);
            this.state = SqlJetPagerState.RESERVED;
            if (exclusive) {
                this.waitOnLock(SqlJetLockType.EXCLUSIVE);
            }
            this.dirtyCache = false;
            SqlJetPager.PAGERTRACE("TRANSACTION %s\n", this.PAGERID());
            if (this.useJournal && !this.tempFile && this.journalMode != SqlJetPagerJournalMode.OFF) {
                this.openJournal();
            }
        } else if (this.journalOpen && this.journalOff == 0L) {
            assert (this.nRec == 0);
            assert (this.dbOrigSize == 0);
            assert (this.pagesInJournal == null);
            this.getPageCount();
            this.pagesInJournal = new BitSet(this.dbSize);
            this.dbOrigSize = this.dbSize;
            this.writeJournalHdr();
        }
        assert (!this.journalOpen || this.journalOff > 0L);
    }

    private void writeJournalHdr() throws SqlJetException {
        SqlJetException rc = null;
        ByteBuffer zHeader = this.tmpSpace;
        int nHeader = this.pageSize;
        if (nHeader > this.JOURNAL_HDR_SZ()) {
            nHeader = this.JOURNAL_HDR_SZ();
        }
        for (int ii = 0; ii < this.nSavepoint; ++ii) {
            if (this.aSavepoint[ii].iHdrOffset != 0L) continue;
            this.aSavepoint[ii].iHdrOffset = this.journalOff;
        }
        this.seekJournalHdr();
        this.journalHdr = this.journalOff;
        SqlJetUtility.memcpy(zHeader, aJournalMagic, aJournalMagic.remaining());
        assert (this.fd != null || this.noSync);
        if (this.noSync || this.journalMode == SqlJetPagerJournalMode.MEMORY || this.fd.deviceCharacteristics().contains((Object)SqlJetDeviceCharacteristics.IOCAP_SAFE_APPEND)) {
            this.put32bits(zHeader, aJournalMagic.remaining(), -1);
        } else {
            this.put32bits(zHeader, aJournalMagic.remaining(), 0);
        }
        this.cksumInit = this.randomnessInt();
        this.put32bitsUnsigned(zHeader, aJournalMagic.remaining() + 4, this.cksumInit);
        this.put32bits(zHeader, aJournalMagic.remaining() + 8, this.dbOrigSize);
        this.put32bits(zHeader, aJournalMagic.remaining() + 12, this.sectorSize);
        SqlJetUtility.memset(zHeader, aJournalMagic.remaining() + 16, (byte)0, nHeader - (aJournalMagic.remaining() + 16));
        if (this.journalHdr == 0L) {
            this.put32bits(zHeader, aJournalMagic.remaining() + 16, this.pageSize);
        }
        for (int nWrite = 0; rc == null && nWrite < this.JOURNAL_HDR_SZ(); nWrite += nHeader) {
            try {
                this.jfd.write(zHeader, nHeader, this.journalOff);
            }
            catch (SqlJetException e) {
                rc = e;
            }
            this.journalOff += (long)nHeader;
        }
        if (rc != null) {
            throw rc;
        }
    }

    private long randomnessInt() {
        return SqlJetUtility.get4byteUnsigned(this.fileSystem.randomness(4));
    }

    private void put32bits(ByteBuffer p, int pos, int v) {
        SqlJetUtility.put4byte(p, pos, v);
    }

    private void put32bits(ByteBuffer p, int v) {
        this.put32bits(p, 0, v);
    }

    private void put32bitsUnsigned(ByteBuffer p, int pos, long v) {
        SqlJetUtility.put4byteUnsigned(p, pos, v);
    }

    private void openSubJournal() throws SqlJetException {
        if (this.journalOpen && this.sjfd == null) {
            this.sjfd = this.journalMode == SqlJetPagerJournalMode.MEMORY ? this.fileSystem.memJournalOpen() : this.openTemp(SqlJetFileType.SUBJOURNAL, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openJournal() throws SqlJetException {
        block23: {
            SqlJetFileType fileType = null;
            EnumSet<SqlJetFileOpenPermission> flags = SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.EXCLUSIVE, SqlJetFileOpenPermission.CREATE);
            SqlJetException rc = null;
            assert (this.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
            assert (this.useJournal);
            assert (this.pagesInJournal == null);
            this.getPageCount();
            this.pagesInJournal = new BitSet(this.dbSize);
            try {
                if (!this.journalOpen) {
                    if (this.tempFile) {
                        flags.add(SqlJetFileOpenPermission.DELETEONCLOSE);
                        fileType = SqlJetFileType.TEMP_JOURNAL;
                    } else {
                        fileType = SqlJetFileType.MAIN_JOURNAL;
                    }
                    try {
                        this.jfd = this.journalMode == SqlJetPagerJournalMode.MEMORY ? this.fileSystem.memJournalOpen() : this.fileSystem.open(this.journal, fileType, flags);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                    assert (rc != null || this.jfd != null);
                    this.journalOff = 0L;
                    this.setMaster = false;
                    this.journalHdr = 0L;
                    if (rc != null) {
                        this.fileSystem.delete(this.journal, false);
                        throw rc;
                    }
                }
                this.journalOpen = true;
                this.journalStarted = false;
                this.needSync = false;
                this.nRec = 0;
                if (this.errCode != null) {
                    rc = new SqlJetException(this.errCode);
                    throw rc;
                }
                this.dbOrigSize = this.dbSize;
                try {
                    this.writeJournalHdr();
                }
                catch (SqlJetException e) {
                    rc = e;
                }
                if (this.nSavepoint > 0 && rc == null) {
                    try {
                        this.openSubJournal();
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
                if (rc == null) break block23;
                rc = null;
                try {
                    this.endTransaction(false);
                }
                catch (SqlJetException e) {
                    rc = e;
                }
                if (rc == null) {
                    rc = new SqlJetException(SqlJetErrorCode.FULL);
                    throw rc;
                }
            }
            finally {
                if (rc != null) {
                    this.pagesInJournal = null;
                    throw rc;
                }
            }
        }
    }

    @Override
    public void commitPhaseOne(String master, boolean noSync) throws SqlJetException {
        block13: {
            if (this.errCode != null) {
                throw new SqlJetException(this.errCode);
            }
            if (!this.dbModified && (this.journalMode != SqlJetPagerJournalMode.DELETE || this.exclusiveMode())) {
                assert (!this.dirtyCache || !this.journalOpen);
                return;
            }
            SqlJetPager.PAGERTRACE("DATABASE SYNC: File=%s zMaster=%s nSize=%d\n", this.fileName, master, this.dbSize);
            try {
                if (this.state != SqlJetPagerState.SYNCED && !this.memDb && this.dirtyCache) {
                    if (!this.setMaster) {
                        this.incrChangeCounter();
                        if (this.journalMode != SqlJetPagerJournalMode.OFF) {
                            if (this.dbSize < this.dbOrigSize) {
                                long iSkip = this.PAGER_MJ_PGNO();
                                int dbSize = this.dbSize;
                                this.dbSize = this.dbOrigSize;
                                for (int i = dbSize + 1; i <= this.dbOrigSize; ++i) {
                                    if (SqlJetUtility.bitSetTest(this.pagesInJournal, i) || (long)i == iSkip) continue;
                                    ISqlJetPage pg = this.getPage(i);
                                    pg.write();
                                    pg.unref();
                                }
                                this.dbSize = dbSize;
                            }
                            this.writeMasterJournal(master);
                            this.syncJournal();
                        }
                    }
                    ISqlJetPage dirtyList = this.pageCache.getDirtyList();
                    this.writePageList(dirtyList);
                    this.pageCache.cleanAll();
                    if (this.dbSize < this.dbFileSize) {
                        assert (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0);
                        this.doTruncate(this.dbSize);
                    }
                    if (!this.noSync && !noSync) {
                        this.fd.sync(this.syncFlags);
                    }
                    this.state = SqlJetPagerState.SYNCED;
                }
            }
            catch (SqlJetIOException e) {
                if (e.getIoErrorCode() != SqlJetIOErrorCode.IOERR_BLOCKED) break block13;
                throw new SqlJetException(SqlJetErrorCode.BUSY);
            }
        }
    }

    private void writePageList(ISqlJetPage pList) throws SqlJetException {
        if (pList == null) {
            return;
        }
        this.waitOnLock(SqlJetLockType.EXCLUSIVE);
        for (ISqlJetPage page = pList; page != null; page = page.getDirty()) {
            if (null == this.fd) {
                assert (this.tempFile);
                this.fd = this.openTemp(this.type, this.permissions);
            }
            if (page.getPageNumber() <= this.dbSize && !page.getFlags().contains((Object)SqlJetPageFlags.DONT_WRITE)) {
                long offset = (page.getPageNumber() - 1) * this.pageSize;
                SqlJetPager.PAGERTRACE("STORE %s page %d hash(%08x)\n", this.PAGERID(), pList.getPageNumber(), this.pageHash(pList));
                ByteBuffer pData = page.getData();
                this.fd.write(pData, this.pageSize, offset);
                if (page.getPageNumber() == 1) {
                    SqlJetUtility.memcpy(this.dbFileVers, 0, pData, 24, this.dbFileVers.remaining());
                }
            } else {
                SqlJetPager.PAGERTRACE("NOSTORE %s page %d\n", this.PAGERID(), pList.getPageNumber());
            }
            page.setHash(this.pageHash(page));
        }
    }

    private ISqlJetFile openTemp(SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        AbstractSet flags = null;
        if (permissions != null) {
            flags = new HashSet();
            for (SqlJetFileOpenPermission sqlJetFileOpenPermission : permissions) {
                flags.add(sqlJetFileOpenPermission);
            }
        } else {
            flags = SqlJetUtility.noneOf(SqlJetFileOpenPermission.class);
        }
        flags.add((SqlJetFileOpenPermission)SqlJetFileOpenPermission.READWRITE);
        flags.add(SqlJetFileOpenPermission.CREATE);
        flags.add(SqlJetFileOpenPermission.EXCLUSIVE);
        flags.add(SqlJetFileOpenPermission.DELETEONCLOSE);
        return this.fileSystem.open(null, type, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMasterJournal(String master) throws SqlJetException {
        int cksum = 0;
        ByteBuffer zBuf = ByteBuffer.allocate(aJournalMagic.remaining() + 8);
        if (null == master || this.setMaster) {
            return;
        }
        if (this.journalMode == SqlJetPagerJournalMode.MEMORY) {
            return;
        }
        this.setMaster = true;
        ByteBuffer zMaster = ByteBuffer.wrap(master.getBytes());
        int len = zMaster.remaining();
        for (int i = 0; i < len; ++i) {
            cksum += SqlJetUtility.getUnsignedByte(zMaster, i);
        }
        if (this.fullSync) {
            this.seekJournalHdr();
        }
        long jrnlOff = this.journalOff;
        this.journalOff += (long)(len + 20);
        SqlJetPager.write32bits(this.jfd, jrnlOff, this.int_PAGER_MJ_PGNO());
        this.jfd.write(zMaster, len, jrnlOff += 4L);
        jrnlOff += (long)len;
        this.put32bits(zBuf, len);
        this.put32bits(zBuf, 4, cksum);
        SqlJetUtility.memcpy(zBuf, 8, aJournalMagic, 0, aJournalMagic.remaining());
        try {
            this.jfd.write(zBuf, zBuf.remaining(), jrnlOff);
        }
        catch (Throwable throwable) {
            jrnlOff += (long)zBuf.remaining();
            this.needSync = !this.noSync;
            throw throwable;
        }
        this.needSync = !this.noSync;
        long jrnlSize = this.jfd.fileSize();
        if (jrnlSize > (jrnlOff += (long)zBuf.remaining())) {
            this.jfd.truncate(jrnlOff);
        }
    }

    private void incrChangeCounter() throws SqlJetException {
        if (!this.changeCountDone && this.dbSize > 0) {
            ISqlJetPage page = this.getPage(1);
            try {
                page.write();
            }
            catch (SqlJetException e) {
                page.unref();
                throw e;
            }
            int change_counter = SqlJetUtility.get4byte(this.dbFileVers);
            this.put32bits(page.getData(), 24, ++change_counter);
            page.unref();
            this.changeCountDone = true;
        }
    }

    @Override
    public void commitPhaseTwo() throws SqlJetException {
        if (null != this.errCode) {
            throw new SqlJetException(this.errCode);
        }
        if (this.state.compareTo(SqlJetPagerState.RESERVED) < 0) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (!(this.dbModified || this.journalMode == SqlJetPagerJournalMode.DELETE && this.exclusiveMode())) {
            assert (!this.dirtyCache || !this.journalOpen);
            return;
        }
        SqlJetPager.PAGERTRACE("COMMIT %s\n", this.PAGERID());
        assert (this.state == SqlJetPagerState.SYNCED || this.memDb || !this.dirtyCache);
        try {
            this.endTransaction(this.setMaster);
        }
        catch (SqlJetException e) {
            this.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SqlJetException {
        block11: {
            SqlJetPager.PAGERTRACE("ROLLBACK %s\n", this.PAGERID());
            if (!this.dirtyCache || !this.journalOpen) {
                this.endTransaction(this.setMaster);
            } else {
                if (null != this.errCode && this.errCode != SqlJetErrorCode.FULL) {
                    if (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0) {
                        this.playback(false);
                    }
                    throw new SqlJetException(this.errCode);
                }
                try {
                    if (this.state == SqlJetPagerState.RESERVED) {
                        try {
                            this.playback(false);
                            break block11;
                        }
                        finally {
                            this.endTransaction(this.setMaster);
                        }
                    }
                    this.playback(false);
                }
                catch (SqlJetException e) {
                    if (!this.memDb) {
                        this.dbSizeValid = false;
                    }
                    this.error(e);
                }
            }
        }
    }

    @Override
    public void sync() throws SqlJetIOException {
        if (!this.memDb) {
            this.fd.sync(this.syncFlags);
        }
    }

    @Override
    public int getRefCount() {
        return this.pageCache.getRefCount();
    }

    @Override
    public void pageCallback(ISqlJetPage page) {
        if (!(page instanceof SqlJetPage)) {
            return;
        }
        SqlJetPage pPg = (SqlJetPage)page;
        if (this.doNotSync) {
            return;
        }
        assert (pPg.getFlags().contains((Object)SqlJetPageFlags.DIRTY));
        if (this.errCode == null) {
            try {
                if (pPg.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                    this.syncJournal();
                    if (this.fullSync && this.journalMode != SqlJetPagerJournalMode.MEMORY && !this.fd.deviceCharacteristics().contains((Object)SqlJetDeviceCharacteristics.IOCAP_SAFE_APPEND)) {
                        this.nRec = 0;
                        this.writeJournalHdr();
                    }
                }
                if (pPg.getPageNumber() > this.dbSize && SqlJetPager.subjRequiresPage(pPg)) {
                    this.subjournalPage(pPg);
                }
                this.writePageList(pPg);
            }
            catch (SqlJetException e) {
                this.error(e);
            }
        }
        SqlJetPager.PAGERTRACE("STRESS %s page %d\n", this.PAGERID(), pPg.pgno);
        this.pageCache.makeClean(pPg);
    }

    @Override
    public void openSavepoint(int nSavepoint) throws SqlJetException {
        if (nSavepoint > this.nSavepoint && this.useJournal) {
            assert (this.nSavepoint == 0 || this.sjfd != null || this.journalMode == SqlJetPagerJournalMode.MEMORY);
            SqlJetCloneable[] aNew = new PagerSavepoint[nSavepoint];
            SqlJetUtility.memcpy(aNew, this.aSavepoint, nSavepoint);
            this.aSavepoint = aNew;
            this.nSavepoint = nSavepoint;
            for (int ii = this.nSavepoint; ii < nSavepoint; ++ii) {
                assert (this.dbSizeValid);
                ((PagerSavepoint)aNew[ii]).nOrig = this.dbSize;
                ((PagerSavepoint)aNew[ii]).iOffset = this.journalOpen && this.journalOff > 0L ? this.journalOff : (long)this.JOURNAL_HDR_SZ();
                ((PagerSavepoint)aNew[ii]).iSubRec = this.stmtNRec;
                ((PagerSavepoint)aNew[ii]).pInSavepoint = new BitSet(this.dbSize);
            }
            this.openSubJournal();
        }
    }

    @Override
    public void savepoint(SqlJetSavepointOperation op, int iSavepoint) throws SqlJetException {
        SqlJetException rc = null;
        assert (op == SqlJetSavepointOperation.RELEASE || op == SqlJetSavepointOperation.ROLLBACK);
        if (iSavepoint < this.nSavepoint) {
            int nNew;
            block11: {
                for (int ii = nNew = iSavepoint + (op == SqlJetSavepointOperation.ROLLBACK ? 1 : 0); ii < this.nSavepoint; ++ii) {
                    this.aSavepoint[ii].pInSavepoint = null;
                }
                this.nSavepoint = nNew;
                if (op == SqlJetSavepointOperation.ROLLBACK && this.jfd != null) {
                    PagerSavepoint pSavepoint = nNew == 0 ? null : this.aSavepoint[nNew - 1];
                    try {
                        this.playbackSavepoint(pSavepoint);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                        if ($assertionsDisabled || rc.getErrorCode() != SqlJetErrorCode.DONE) break block11;
                        throw new AssertionError();
                    }
                }
            }
            if (nNew == 0 && op == SqlJetSavepointOperation.RELEASE && this.sjfd != null) {
                assert (rc == null);
                try {
                    this.sjfd.truncate(0L);
                }
                catch (SqlJetException e) {
                    rc = e;
                }
                this.stmtNRec = 0;
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    private class PagerSavepoint
    extends SqlJetCloneable {
        long iOffset;
        long iHdrOffset;
        BitSet pInSavepoint;
        int nOrig;
        int iSubRec;

        private PagerSavepoint() {
        }
    }
}

