/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetError;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMutex;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetUtility {
    private static final Logger logger = Logger.getLogger("SIGNED");

    public static String getSysProp(String propName, String defValue) throws SqlJetError {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return System.getProperty(propName, defValue);
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static int getIntSysProp(String propName, int defValue) throws SqlJetError {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return Integer.valueOf(System.getProperty(propName, Integer.toString(defValue)));
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static boolean getBoolSysProp(String propName, boolean defValue) {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return Boolean.valueOf(System.getProperty(propName, Boolean.toString(defValue)));
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static <T extends Enum<T>> T getEnumSysProp(String propName, T defValue) {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        if (null == defValue) {
            throw new SqlJetError("Undefined default value");
        }
        try {
            return Enum.valueOf(defValue.getDeclaringClass(), System.getProperty(propName, defValue.toString()));
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static int get2byte(ByteBuffer x) {
        return SqlJetUtility.get2byte(x, 0);
    }

    public static int get2byte(ByteBuffer x, int off) {
        return SqlJetUtility.toUnsigned(x.getShort(off));
    }

    public static void put2byte(ByteBuffer p, int v) {
        SqlJetUtility.put2byte(p, 0, v);
    }

    public static void put2byte(ByteBuffer p, int off, int v) {
        p.putShort(off, SqlJetUtility.fromUnsigned(v));
    }

    public static ByteBuffer put4byte(int v) {
        if (v < 0) {
            SqlJetUtility.log(logger, "signed %d", v);
        }
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(0, v);
        b.rewind();
        return b;
    }

    public static int get4byte(ByteBuffer p) {
        return SqlJetUtility.get4byte(p, 0);
    }

    public static int get4byte(ByteBuffer p, int pos) {
        int v = p.getInt(pos);
        if (v < 0) {
            SqlJetUtility.log(logger, "signed %d", v);
        }
        return v;
    }

    public static void put4byte(ByteBuffer p, int pos, long v) {
        if (null == p || p.capacity() - pos < 4) {
            throw new SqlJetError("Wrong destination");
        }
        if (v < 0L) {
            SqlJetUtility.log(logger, "signed %d", v);
        }
        p.putInt(pos, SqlJetUtility.fromUnsigned(v));
    }

    public static void put4byte(ByteBuffer p, long v) {
        SqlJetUtility.put4byte(p, 0, v);
    }

    public static void memcpy(byte[] dest, byte[] src, int length) {
        System.arraycopy(src, 0, dest, 0, length);
    }

    public static void memcpy(byte[] dest, int dstPos, byte[] src, int srcPos, int length) {
        System.arraycopy(src, srcPos, dest, dstPos, length);
    }

    public static void memcpy(ByteBuffer dest, ByteBuffer src, int length) {
        System.arraycopy(src.array(), src.arrayOffset(), dest.array(), dest.arrayOffset(), length);
    }

    public static void memcpy(ByteBuffer dest, int dstPos, ByteBuffer src, int srcPos, int length) {
        System.arraycopy(src.array(), src.arrayOffset() + srcPos, dest.array(), dest.arrayOffset() + dstPos, length);
    }

    public static void memcpy(SqlJetCloneable[] dest, SqlJetCloneable[] src, int length) throws SqlJetException {
        SqlJetUtility.memcpy(src, 0, dest, 0, length);
    }

    public static <T extends SqlJetCloneable> T memcpy(T src) throws SqlJetException {
        try {
            return (T)((SqlJetCloneable)src.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)e);
        }
    }

    private static void memcpy(SqlJetCloneable[] src, int srcPos, SqlJetCloneable[] dest, int dstPos, int length) throws SqlJetException {
        int x = srcPos;
        for (int y = dstPos; x < src.length && y < dest.length; ++x, ++y) {
            SqlJetCloneable o = src[x];
            if (null == o) continue;
            try {
                dest[y] = (SqlJetCloneable)o.clone();
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)e);
            }
        }
    }

    public static void memset(byte[] data, int from, byte value, int count) {
        Arrays.fill(data, from, from + count, value);
    }

    public static void memset(byte[] data, byte value, int count) {
        SqlJetUtility.memset(data, 0, value, count);
    }

    public static void memset(byte[] data, byte value) {
        SqlJetUtility.memset(data, value, data.length);
    }

    public static void memset(ByteBuffer data, int from, byte value, int count) {
        int i = data.arrayOffset() + from;
        Arrays.fill(data.array(), i, i + count, value);
    }

    public static void memset(ByteBuffer data, byte value, int count) {
        SqlJetUtility.memset(data, 0, value, count);
    }

    public static void memset(ByteBuffer data, byte value) {
        SqlJetUtility.memset(data, value, data.capacity());
    }

    public static int strlen(byte[] s, int from) {
        int p;
        for (p = from; p < s.length && s[p] != 0; ++p) {
        }
        return p - from;
    }

    public static int strlen(ByteBuffer s, int from) {
        int p;
        for (p = from; p < s.remaining() && SqlJetUtility.getUnsignedByte(s, p) != 0; ++p) {
        }
        return p - from;
    }

    public static boolean bitSetTest(BitSet bitSet, int index) {
        if (bitSet == null) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        return bitSet.get(index);
    }

    public static int memcmp(byte[] a1, byte[] a2, int count) {
        for (int i = 0; i < count; ++i) {
            Byte b2;
            Byte b1 = a1[i];
            int c = b1.compareTo(b2 = Byte.valueOf(a2[i]));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static int memcmp(byte[] a1, int from1, byte[] a2, int from2, int count) {
        for (int i = 0; i < count; ++i) {
            Byte b2;
            Byte b1 = a1[from1 + i];
            int c = b1.compareTo(b2 = Byte.valueOf(a2[from2 + i]));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static int memcmp(ByteBuffer a1, ByteBuffer a2, int count) {
        for (int i = 0; i < count; ++i) {
            short b2;
            short b1 = SqlJetUtility.getUnsignedByte(a1, i);
            int c = b1 - (b2 = SqlJetUtility.getUnsignedByte(a2, i));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static byte[] addZeroByteEnd(byte[] b) {
        if (null == b) {
            throw new SqlJetError("Undefined byte array");
        }
        byte[] r = new byte[b.length + 1];
        SqlJetUtility.memcpy(r, b, b.length);
        r[b.length] = 0;
        return r;
    }

    public static byte[] getBytes(String string) {
        if (null == string) {
            throw new SqlJetError("Undefined string");
        }
        try {
            return string.getBytes("UTF8");
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get bytes for string \"" + string + "\"", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer slice(ByteBuffer b, int pos) {
        if (pos < 0) {
            return ByteBuffer.wrap(b.array(), b.arrayOffset() + pos, b.remaining() - pos).slice();
        }
        b.mark();
        try {
            b.position(pos);
            ByteBuffer byteBuffer = b.slice();
            return byteBuffer;
        }
        finally {
            b.reset();
        }
    }

    public static int putVarint(ByteBuffer p, long v) {
        if ((v & 0xFF00000000000000L) != 0L) {
            SqlJetUtility.putUnsignedByte(p, 8, (byte)v);
            v >>= 8;
            for (int i = 7; i >= 0; --i) {
                SqlJetUtility.putUnsignedByte(p, i, (byte)(v & 0x7FL | 0x80L));
                v >>= 7;
            }
            return 9;
        }
        int n = 0;
        byte[] buf = new byte[10];
        do {
            buf[n++] = (byte)(v & 0x7FL | 0x80L);
        } while ((v >>= 7) != 0L);
        buf[0] = (byte)(buf[0] & 0x7F);
        assert (n <= 9);
        int i = 0;
        int j = n - 1;
        while (j >= 0) {
            SqlJetUtility.putUnsignedByte(p, i, buf[j]);
            --j;
            ++i;
        }
        return n;
    }

    public static int putVarint32(ByteBuffer p, int v) {
        if (v < 128) {
            SqlJetUtility.putUnsignedByte(p, 0, (byte)v);
            return 1;
        }
        if ((v & 0xFFFFFF80) == 0) {
            SqlJetUtility.putUnsignedByte(p, 0, (byte)v);
            return 1;
        }
        if ((v & 0xFFFFC000) == 0) {
            SqlJetUtility.putUnsignedByte(p, 0, (byte)(v >> 7 | 0x80));
            SqlJetUtility.putUnsignedByte(p, 1, (byte)(v & 0x7F));
            return 2;
        }
        return SqlJetUtility.putVarint(p, v);
    }

    public static byte getVarint(ByteBuffer p, long[] v) {
        return SqlJetUtility.getVarint(p, 0, v);
    }

    public static byte getVarint(ByteBuffer p, int offset, long[] v) {
        long l = 0L;
        for (byte i = 0; i < 8; i = (byte)((byte)(i + 1))) {
            short b = SqlJetUtility.getUnsignedByte(p, i + offset);
            l = l << 7 | (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            v[0] = l;
            i = (byte)(i + 1);
            return i;
        }
        short b = SqlJetUtility.getUnsignedByte(p, 8 + offset);
        v[0] = l = l << 8 | (long)b;
        return 9;
    }

    public static byte getVarint32(ByteBuffer p, int[] v) {
        return SqlJetUtility.getVarint32(p, 0, v);
    }

    public static byte getVarint32(ByteBuffer p, int offset, int[] v) {
        int b;
        short x = SqlJetUtility.getUnsignedByte(p, 0 + offset);
        if (x < 128) {
            v[0] = x;
            return 1;
        }
        int i = 0;
        int a = SqlJetUtility.getUnsignedByte(p, i + offset);
        if ((a & 0x80) == 0) {
            v[0] = a;
            return 1;
        }
        if (((b = SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            a &= 0x7F;
            v[0] = (a <<= 7) | b;
            return 2;
        }
        a <<= 14;
        if (((a |= SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            b &= 0x7F;
            v[0] = (a &= 0x1FC07F) | (b <<= 7);
            return 3;
        }
        b <<= 14;
        if (((b |= SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            a &= 0x1FC07F;
            v[0] = (a <<= 7) | (b &= 0x1FC07F);
            return 4;
        }
        a <<= 14;
        if (((a |= SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            b &= 0xF01FC07F;
            v[0] = (a &= 0xF01FC07F) | (b <<= 7);
            return 5;
        }
        long[] v64 = new long[1];
        i -= 4;
        byte n = SqlJetUtility.getVarint(p, offset, v64);
        assert (n > 5 && n <= 9);
        v[0] = (int)v64[0];
        return n;
    }

    public static int sqlite3VarintLen(long v) {
        int i = 0;
        while ((v >>= 7) != 0L && ++i < 9) {
        }
        return i;
    }

    public static boolean mutex_held(ISqlJetMutex mutex) {
        return mutex == null || mutex.held();
    }

    public static int strlen30(ByteBuffer z) {
        int i;
        int l = z.limit();
        for (i = 0; i < l && SqlJetUtility.getUnsignedByte(z, i) != 0; ++i) {
        }
        return 0x3FFFFFFF & i;
    }

    public static short getUnsignedByte(ByteBuffer byteBuffer, int index) {
        return (short)(byteBuffer.get(index) & 0xFF);
    }

    public static ByteBuffer putUnsignedByte(ByteBuffer byteBuffer, int index, short value) {
        return byteBuffer.put(index, (byte)(value & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ByteBuffer buf) {
        ByteBuffer byteBuffer = buf;
        synchronized (byteBuffer) {
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            buf.rewind();
            return new String(bytes);
        }
    }

    public static String toString(ByteBuffer buf, SqlJetEncoding enc) throws SqlJetException {
        if (buf == null) {
            return null;
        }
        if (enc == null) {
            return null;
        }
        ByteBuffer byteBuffer = buf;
        synchronized (byteBuffer) {
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            buf.rewind();
            try {
                return new String(bytes, enc.getCharsetName());
            }
            catch (UnsupportedEncodingException e) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Unknown charset " + enc.name());
            }
        }
    }

    public static ByteBuffer fromString(String s, SqlJetEncoding enc) throws SqlJetException {
        try {
            return ByteBuffer.wrap(s.getBytes(enc.getCharsetName()));
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Unknown charset " + enc.name());
        }
    }

    public static ByteBuffer translate(ByteBuffer buf, SqlJetEncoding from, SqlJetEncoding to) throws SqlJetException {
        return SqlJetUtility.fromString(SqlJetUtility.toString(buf, from), to);
    }

    public static String trim(String s) {
        return null != s ? s.trim() : null;
    }

    public static int varintLen(long v) {
        int i = 0;
        while ((v >>= 7) != 0L && ++i < 9) {
        }
        return i;
    }

    public static void log(Logger logger, String format, Object ... args) {
        StackTraceElement[] stackTrace;
        StringBuilder s = new StringBuilder();
        s.append(String.format(format, args)).append('\n');
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            String l = stackTraceElement.toString();
            if (!l.startsWith("org.tmatesoft.sqljet")) continue;
            s.append('\t').append(l).append('\n');
        }
        logger.info(s.toString());
    }

    public static short toUnsigned(byte value) {
        return (short)(value & 0xFF);
    }

    public static byte fromUnsigned(short value) {
        return (byte)(value & 0xFF);
    }

    public static int toUnsigned(short value) {
        return value & 0xFFFF;
    }

    public static short fromUnsigned(int value) {
        return (short)(value & 0xFFFF);
    }

    public static long toUnsigned(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int fromUnsigned(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public static long get4byteUnsigned(byte[] p) {
        return SqlJetUtility.get4byteUnsigned(ByteBuffer.wrap(p));
    }

    public static long get4byteUnsigned(byte[] p, int pos) {
        return SqlJetUtility.get4byteUnsigned(ByteBuffer.wrap(p));
    }

    public static ByteBuffer put4byteUnsigned(long v) {
        if (v < 0L) {
            SqlJetUtility.log(logger, "signed %d", v);
        }
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(0, SqlJetUtility.fromUnsigned(v)).rewind();
        return b;
    }

    public static void put4byteUnsigned(byte[] p, int pos, long v) {
        SqlJetUtility.put4byteUnsigned(ByteBuffer.wrap(p), pos, v);
    }

    public static long get4byteUnsigned(ByteBuffer p) {
        return SqlJetUtility.get4byteUnsigned(p, 0);
    }

    public static long get4byteUnsigned(ByteBuffer p, int pos) {
        long v = SqlJetUtility.toUnsigned(p.getInt(pos));
        if (v < 0L) {
            SqlJetUtility.log(logger, "signed %d", v);
        }
        return v;
    }

    public static void put4byteUnsigned(ByteBuffer p, int pos, long v) {
        if (null == p || p.capacity() - pos < 4) {
            throw new SqlJetError("Wrong destination");
        }
        if (v < 0L) {
            SqlJetUtility.log(logger, "signed %d", v);
        }
        p.putInt(pos, SqlJetUtility.fromUnsigned(v));
    }

    public static void put4byteUnsigned(ByteBuffer p, long v) {
        SqlJetUtility.put4byteUnsigned(p, 0, v);
    }

    public static void memmove(ByteBuffer dst, ByteBuffer src, int n) {
        byte[] b = new byte[n];
        src.get(b, 0, n);
        dst.put(b, 0, n);
    }

    public static double atof(ByteBuffer z) {
        String s = SqlJetUtility.toString(z);
        return Double.valueOf(s);
    }

    public static Long atoi64(String str) {
        return Long.valueOf(str);
    }

    public static long absolute(long i) {
        long u;
        long l = u = i < 0L ? -i : i;
        if (u == Integer.MIN_VALUE || u == Long.MIN_VALUE) {
            --u;
        }
        return u;
    }

    public static Object[] addArrays(Object[] array1, Object[] array2) {
        Object[] a = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, a, 0, array1.length);
        System.arraycopy(array2, 0, a, array1.length, array2.length);
        return a;
    }

    public static Object[] insertArray(Object[] intoArray, Object[] insertArray, int pos) {
        Object[] a = new Object[intoArray.length + insertArray.length];
        System.arraycopy(intoArray, 0, a, 0, pos);
        System.arraycopy(insertArray, 0, a, pos, insertArray.length);
        System.arraycopy(intoArray, pos, a, insertArray.length + pos, intoArray.length - pos);
        return a;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E ... e) {
        return EnumSet.of(e1, e);
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e) {
        return EnumSet.of(e);
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2) {
        return EnumSet.of(e1, e2);
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3) {
        return EnumSet.of(e1, e2, e3);
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> elementType) {
        return EnumSet.noneOf(elementType);
    }

    public static Object[] adjustNumberTypes(Object[] key) {
        if (null == key) {
            return null;
        }
        for (int i = 0; i < key.length; ++i) {
            Object obj = key[i];
            if (!(obj instanceof Number)) continue;
            if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer) {
                key[i] = ((Number)obj).longValue();
                continue;
            }
            if (!(obj instanceof Float)) continue;
            key[i] = Double.parseDouble(Float.toString(((Float)obj).floatValue()));
        }
        return key;
    }

    public static ByteBuffer streamToBuffer(InputStream stream) throws SqlJetException {
        if (stream == null) {
            return null;
        }
        try {
            byte[] b = new byte[stream.available()];
            int i = stream.read(b);
            stream.reset();
            return ByteBuffer.wrap(b, 0, i);
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
        }
    }

    public static byte[] readByteBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array).rewind();
        return array;
    }

    public static Object[] copyArray(Object[] array) {
        if (null == array) {
            return null;
        }
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    static {
        logger.setLevel(SqlJetUtility.getBoolSysProp("LOG_SIGNED", false) ? Level.ALL : Level.OFF);
    }
}

