package de.ugoe.cs.swe.exercises.settings;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Button;

public class SettingsProfileComposite extends Composite {
	private Text svnWorkingCopyText;
	private Text svnUsernameText;
	private Text svnPasswordText;
	private Text mysqlUsernameText;
	private Text mysqlPasswordText;
	private Text pdfLatexText;
	private Text profileText;
	private Combo mysqlSSLCombo;

	public SettingsProfileComposite(Composite parent, int style) {
		super(parent, SWT.NONE);
		setLayout(new GridLayout(3, false));
		{
			Label lblProfileFile = new Label(this, SWT.NONE);
			lblProfileFile.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblProfileFile.setText("Profile File");
		}
		{
			profileText = new Text(this, SWT.BORDER);
			profileText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
					false, 1, 1));
		}
		{
			Button btnBrowseProfile = new Button(this, SWT.NONE);
			btnBrowseProfile.setText("Browse");
		}
		{
			Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
			label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
					false, 3, 1));
		}
		{
			Label lblSvnWorkingCopy = new Label(this, SWT.NONE);
			lblSvnWorkingCopy.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblSvnWorkingCopy.setText("SVN Working Copy");
		}
		{
			svnWorkingCopyText = new Text(this, SWT.BORDER);
			svnWorkingCopyText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
					true, false, 1, 1));
		}
		{
			Button btnBrowseSVNWorkingCopy = new Button(this, SWT.NONE);
			btnBrowseSVNWorkingCopy.setText("Browse");
		}
		{
			Label lblSvnUsername = new Label(this, SWT.NONE);
			lblSvnUsername.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblSvnUsername.setText("SVN Username");
		}
		{
			svnUsernameText = new Text(this, SWT.BORDER);
			svnUsernameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
					true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblSvnPassword = new Label(this, SWT.NONE);
			lblSvnPassword.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblSvnPassword.setText("SVN Password");
		}
		{
			svnPasswordText = new Text(this, SWT.BORDER | SWT.PASSWORD);
			svnPasswordText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
					true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
			label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
					false, 3, 1));
		}
		{
			Label lblMysqlUsername = new Label(this, SWT.NONE);
			lblMysqlUsername.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblMysqlUsername.setText("MySQL Username");
		}
		{
			mysqlUsernameText = new Text(this, SWT.BORDER);
			mysqlUsernameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
					true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlPassword = new Label(this, SWT.NONE);
			lblMysqlPassword.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblMysqlPassword.setText("MySQL Password");
		}
		{
			mysqlPasswordText = new Text(this, SWT.BORDER | SWT.PASSWORD);
			mysqlPasswordText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
					true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlSsl = new Label(this, SWT.NONE);
			lblMysqlSsl.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblMysqlSsl.setText("MySQL SSL");
		}
		{
			mysqlSSLCombo = new Combo(this, SWT.READ_ONLY);
			mysqlSSLCombo.add("Disabled");
			mysqlSSLCombo.add("Enabled");
			mysqlSSLCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
					true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
			label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
					false, 3, 1));
		}
		{
			Label lblPdfLatexPath = new Label(this, SWT.NONE);
			lblPdfLatexPath.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER,
					false, false, 1, 1));
			lblPdfLatexPath.setText("pdfLatex Path");
		}
		{
			pdfLatexText = new Text(this, SWT.BORDER);
			pdfLatexText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
					false, 1, 1));
		}
		{
			Button btnBrowsePdfLatex = new Button(this, SWT.NONE);
			btnBrowsePdfLatex.setText("Browse");
		}

	}

	@Override
	protected void checkSubclass() {
	}

	public Text getSvnWorkingCopyText() {
		return svnWorkingCopyText;
	}

	public void setSvnWorkingCopyText(Text svnWorkingCopyText) {
		this.svnWorkingCopyText = svnWorkingCopyText;
	}

	public Text getSvnUsernameText() {
		return svnUsernameText;
	}

	public void setSvnUsernameText(Text svnUsernameText) {
		this.svnUsernameText = svnUsernameText;
	}

	public Text getSvnPasswordText() {
		return svnPasswordText;
	}

	public void setSvnPasswordText(Text svnPasswordText) {
		this.svnPasswordText = svnPasswordText;
	}

	public Text getMysqlUsernameText() {
		return mysqlUsernameText;
	}

	public void setMysqlUsernameText(Text mysqlUsernameText) {
		this.mysqlUsernameText = mysqlUsernameText;
	}

	public Text getMysqlPasswordText() {
		return mysqlPasswordText;
	}

	public void setMysqlPasswordText(Text mysqlPasswordText) {
		this.mysqlPasswordText = mysqlPasswordText;
	}

	public Text getPdfLatexText() {
		return pdfLatexText;
	}

	public void setPdfLatexText(Text pdfLatexText) {
		this.pdfLatexText = pdfLatexText;
	}

	public Combo getMysqlSSLCombo() {
		return mysqlSSLCombo;
	}

	public void setMysqlSSLCombo(Combo mysqlSSLCombo) {
		this.mysqlSSLCombo = mysqlSSLCombo;
	}

	public Text getProfileText() {
		return profileText;
	}

	public void setProfileText(Text profileText) {
		this.profileText = profileText;
	}

}
