package de.ugoe.cs.swe.exercises.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;

import de.ugoe.cs.swe.exercises.exercise.ExerciseSVN;

public class FileUtils {

	public static void copyFile(File in, File out) throws IOException {
		FileChannel inChannel = new FileInputStream(in).getChannel();
		FileChannel outChannel = new FileOutputStream(out).getChannel();
		try {
			inChannel.transferTo(0, inChannel.size(), outChannel);
		} catch (IOException e) {
			throw e;
		} finally {
			if (inChannel != null)
				inChannel.close();
			if (outChannel != null)
				outChannel.close();
		}
	}

	public static void renameFile(String oldName, String newName) {

		File oldFile = new File(ExerciseSVN.SVNpath + "exercisesheets/"
				+ oldName);
		File newFile = new File(ExerciseSVN.SVNpath + "exercisesheets/"
				+ newName);

		try {
			copyFile(oldFile, newFile);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.err.println(e);
		}
		oldFile.delete();
	}

	public static String readFileAsString(String filePath) throws IOException {
		BufferedReader br = new BufferedReader(new InputStreamReader(
				new FileInputStream(filePath)));
		StringBuffer contentOfFile = new StringBuffer();
		String line;
		while ((line = br.readLine()) != null) {
			contentOfFile.append(line);
		}
		return contentOfFile.toString();
	}

	public static void writeStringAsFile(String filePath, String content)
			throws IOException {
		try {
			BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
			out.write(content);
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
