package de.ugoe.cs.swe.exercises.settings;

import java.io.File;
import java.io.IOException;
import com.thoughtworks.xstream.XStream;
import de.ugoe.cs.swe.exercises.misc.FileUtils;

public class Settings {
	private String svnLocation;
	private String workingDirectory;
	private String svnUsername;
	private String svnPassword;
	private String mysqlHost;
	private String mysqlDb;
	private String mysqlUsername;
	private String mysqlPassword;
	private String pdfLatexPath;
	private String researchGroup;
	private String researchGroupUrl;
	private boolean mysqlSSL = false;
	private static Settings settings;

	private Settings() {
	}

	public static Settings getInstance() {
		if (settings == null)
			settings = new Settings();

		return settings;
	}

	public boolean isInitialized() {
		if (svnLocation == "" || workingDirectory == "" || svnUsername == ""
				|| svnPassword == "" || mysqlHost == "" || mysqlDb == ""
				|| mysqlUsername == "" || mysqlPassword == ""
				|| pdfLatexPath == "") {
			return false;
		}
		return true;

	}

	private String nullCheck(String str) {
		if (str == null)
			return "";
		else
			return str;
			
	}
	
	public String getSvnLocation() {
		return nullCheck(svnLocation);
	}

	public void setSvnLocation(String svnLocation) {
		this.svnLocation = svnLocation;
	}

	public String getWorkingDirectory() {
		return nullCheck(workingDirectory);
	}

	public void setWorkingDirectory(String workingDirectory) {
		this.workingDirectory = workingDirectory;
	}

	public String getSvnUsername() {
		return nullCheck(svnUsername);
	}

	public void setSvnUsername(String svnUsername) {
		this.svnUsername = svnUsername;
	}

	public String getSvnPassword() {
		return nullCheck(svnPassword);
	}

	public void setSvnPassword(String svnPassword) {
		this.svnPassword = svnPassword;
	}

	public String getMysqlHost() {
		return nullCheck(mysqlHost);
	}

	public void setMysqlHost(String mysqlHost) {
		this.mysqlHost = mysqlHost;
	}

	public String getMysqlDb() {
		return nullCheck(mysqlDb);
	}

	public void setMysqlDb(String mysqlDb) {
		this.mysqlDb = mysqlDb;
	}

	public String getMysqlUsername() {
		return nullCheck(mysqlUsername);
	}

	public void setMysqlUsername(String mysqlUsername) {
		this.mysqlUsername = mysqlUsername;
	}

	public String getMysqlPassword() {
		return nullCheck(mysqlPassword);
	}

	public void setMysqlPassword(String mysqlPassword) {
		this.mysqlPassword = mysqlPassword;
	}

	public String getPdfLatexPath() {
		return nullCheck(pdfLatexPath);
	}

	public void setPdfLatexPath(String pdfLatexPath) {
		this.pdfLatexPath = pdfLatexPath;
	}

	public String getResearchGroup() {
		return nullCheck(researchGroup);
	}

	public void setResearchGroup(String researchGroup) {
		this.researchGroup = researchGroup;
	}

	public String getResearchGroupUrl() {
		return nullCheck(researchGroupUrl);
	}

	public void setResearchGroupUrl(String researchGroupUrl) {
		this.researchGroupUrl = researchGroupUrl;
	}

	public boolean isMysqlSSL() {
		return mysqlSSL;
	}

	public void setMysqlSSL(boolean mysqlSSL) {
		this.mysqlSSL = mysqlSSL;
	}

	public void load() {
		File file = new File(System.getProperty("user.home")
				+ "/exercises_settings.xml");
		if (file.exists()) {
			try {
				String content = FileUtils.readFileAsString(file.getAbsolutePath());
				XStream xstream = new XStream();
				xstream.alias("ExercisesSettings", Settings.class);
				settings = (Settings) xstream.fromXML(content);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public void save() {
		File file = new File(System.getProperty("user.home")
				+ "/exercises_settings.xml");

		XStream xstream = new XStream();
		xstream.alias("ExercisesSettings", Settings.class);
		String xml = xstream.toXML(settings);
		try {
			FileUtils.writeStringAsFile(file.getAbsolutePath(), xml);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Settings [mysqlDb=");
		builder.append(mysqlDb);
		builder.append(", mysqlHost=");
		builder.append(mysqlHost);
		builder.append(", mysqlPassword=");
		builder.append(mysqlPassword);
		builder.append(", mysqlSSL=");
		builder.append(mysqlSSL);
		builder.append(", mysqlUsername=");
		builder.append(mysqlUsername);
		builder.append(", pdfLatexPath=");
		builder.append(pdfLatexPath);
		builder.append(", researchGroup=");
		builder.append(researchGroup);
		builder.append(", researchGroupUrl=");
		builder.append(researchGroupUrl);
		builder.append(", svnLocation=");
		builder.append(svnLocation);
		builder.append(", svnPassword=");
		builder.append(svnPassword);
		builder.append(", svnUsername=");
		builder.append(svnUsername);
		builder.append(", workingDirectory=");
		builder.append(workingDirectory);
		builder.append("]");
		return builder.toString();
	}

	
	
}
