/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetSchema
implements ISqlJetSchema {
    private static final String CANT_DELETE_IMPLICIT_INDEX = "Can't delete implicit index \"%s\"";
    private static final String CREATE_TABLE_SQLITE_SEQUENCE = "CREATE TABLE sqlite_sequence(name,seq)";
    private static final String SQLITE_SEQUENCE = "SQLITE_SEQUENCE";
    private static final Set<SqlJetBtreeTableCreateFlags> BTREE_CREATE_TABLE_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.INTKEY, SqlJetBtreeTableCreateFlags.LEAFDATA);
    private static final Set<SqlJetBtreeTableCreateFlags> BTREE_CREATE_INDEX_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.ZERODATA);
    private static final int TYPE_FIELD = 0;
    private static final int NAME_FIELD = 1;
    private static final int TABLE_FIELD = 2;
    private static final int PAGE_FIELD = 3;
    private static final int SQL_FIELD = 4;
    private static final String TABLE_TYPE = "table";
    private static final String INDEX_TYPE = "index";
    private final ISqlJetDbHandle db;
    private final ISqlJetBtree btree;
    private final Map<String, ISqlJetTableDef> tableDefs = new TreeMap<String, ISqlJetTableDef>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ISqlJetIndexDef> indexDefs = new TreeMap<String, ISqlJetIndexDef>(String.CASE_INSENSITIVE_ORDER);

    public SqlJetSchema(ISqlJetDbHandle db, ISqlJetBtree btree) throws SqlJetException {
        this.db = db;
        this.btree = btree;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SqlJetException {
        if (this.db.getOptions().getSchemaVersion() == 0) {
            return;
        }
        SqlJetBtreeTable table = new SqlJetBtreeTable(this.db, this.btree, 1, false, false);
        try {
            table.lock();
            try {
                this.readShema(table);
            }
            finally {
                table.unlock();
            }
        }
        finally {
            table.close();
        }
    }

    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    public ISqlJetBtree getBtree() {
        return this.btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getTableNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.tableDefs.keySet());
            return hashSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetTableDef getTable(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.tableDefs.get(name);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getIndexNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.indexDefs.keySet());
            return hashSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetIndexDef getIndex(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.indexDefs.get(name);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ISqlJetIndexDef> getIndexes(String tableName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            HashSet<ISqlJetIndexDef> result = new HashSet<ISqlJetIndexDef>();
            for (ISqlJetIndexDef index : this.indexDefs.values()) {
                if (!index.getTableName().equals(tableName)) continue;
                result.add(index);
            }
            Set<ISqlJetIndexDef> set = Collections.unmodifiableSet(result);
            return set;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    private void readShema(SqlJetBtreeTable table) throws SqlJetException {
        ISqlJetBtreeRecord record = table.getRecord();
        while (!table.eof()) {
            int page;
            String name;
            String type = SqlJetUtility.trim(record.getStringField(0, this.db.getOptions().getEncoding()));
            if (null != type && null != (name = SqlJetUtility.trim(record.getStringField(1, this.db.getOptions().getEncoding()))) && 0 != (page = (int)record.getIntField(3))) {
                if (TABLE_TYPE.equals(type)) {
                    String sql = record.getStringField(4, this.db.getOptions().getEncoding());
                    CommonTree ast = this.parseTable(sql);
                    SqlJetTableDef tableDef = new SqlJetTableDef(ast, page);
                    if (!name.equals(tableDef.getName())) {
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                    tableDef.setRowId(table.getCursor().getKeySize());
                    this.tableDefs.put(name, tableDef);
                } else if (INDEX_TYPE.equals(type)) {
                    String tableName = SqlJetUtility.trim(record.getStringField(2, this.db.getOptions().getEncoding()));
                    if (null == type) {
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                    String sql = record.getStringField(4, this.db.getOptions().getEncoding());
                    if (null != sql) {
                        CommonTree ast = this.parseIndex(sql);
                        SqlJetIndexDef indexDef = new SqlJetIndexDef(ast, page);
                        if (!name.equals(indexDef.getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (!tableName.equals(indexDef.getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        indexDef.setRowId(table.getCursor().getKeySize());
                        this.indexDefs.put(name, indexDef);
                    } else {
                        SqlJetBaseIndexDef indexDef = new SqlJetBaseIndexDef(name, tableName, page);
                        indexDef.setRowId(table.getCursor().getKeySize());
                        this.indexDefs.put(name, indexDef);
                    }
                }
            }
            table.next();
            record = table.getRecord();
        }
    }

    private CommonTree parseTable(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer((CharStream)chars);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokens);
            return (CommonTree)parser.create_table_stmt().getTree();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    private CommonTree parseIndex(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer((CharStream)chars);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokens);
            return (CommonTree)parser.create_index_stmt().getTree();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.db.getMutex().enter();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Tables:\n");
            for (ISqlJetTableDef tableDef : this.tableDefs.values()) {
                buffer.append(tableDef.toString());
                buffer.append('\n');
            }
            buffer.append("Indexes:\n");
            for (ISqlJetIndexDef indexDef : this.indexDefs.values()) {
                buffer.append(indexDef.toString());
                buffer.append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef createTable(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.createTableSafe(sql);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetTableDef createTableSafe(String sql) throws SqlJetException {
        CommonTree ast = this.parseTable(sql);
        SqlJetTableDef tableDef = new SqlJetTableDef(ast, 0);
        if (null == tableDef.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = tableDef.getName().trim();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.tableDefs.containsKey(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table \"" + tableName + "\" exists already");
        }
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        if (null == columns || 0 == columns.size()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetBtreeTable schemaTable = new SqlJetBtreeTable(this.db, this.btree, 1, true, false);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int page = this.btree.createTable(BTREE_CREATE_TABLE_FLAGS);
                ISqlJetBtreeRecord record = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), TABLE_TYPE, tableName, tableName, page, tableDef.toSQL());
                ByteBuffer pData = record.getRawRecord();
                long rowId = schemaTable.newRowId();
                schemaTable.getCursor().insert(null, rowId, pData, pData.remaining(), 0, false);
                this.addConstraints(schemaTable, tableDef);
                tableDef.setPage(page);
                tableDef.setRowId(rowId);
                this.tableDefs.put(tableName, tableDef);
                SqlJetTableDef sqlJetTableDef = tableDef;
                schemaTable.unlock();
                return sqlJetTableDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
        }
        finally {
            schemaTable.close();
        }
    }

    private void addConstraints(SqlJetBtreeTable schemaTable, SqlJetTableDef tableDef) throws SqlJetException {
        String tableName = tableDef.getName().trim();
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        int i = 0;
        for (ISqlJetColumnDef column : columns) {
            List<ISqlJetColumnConstraint> constraints = column.getConstraints();
            if (null == constraints) continue;
            for (ISqlJetColumnConstraint constraint : constraints) {
                if (constraint instanceof ISqlJetColumnPrimaryKey) {
                    ISqlJetColumnPrimaryKey pk = (ISqlJetColumnPrimaryKey)constraint;
                    if (!column.hasExactlyIntegerType()) {
                        if (pk.isAutoincremented()) {
                            throw new SqlJetException(SqlJetErrorCode.ERROR, "AUTOINCREMENT is allowed only for INTEGER PRIMARY KEY fields");
                        }
                        this.createAutoIndex(schemaTable, tableName, SqlJetBtreeTable.generateAutoIndexName(tableName, ++i));
                        continue;
                    }
                    if (!pk.isAutoincremented()) continue;
                    this.checkSequenceTable();
                    continue;
                }
                if (!(constraint instanceof ISqlJetColumnUnique)) continue;
                this.createAutoIndex(schemaTable, tableName, SqlJetBtreeTable.generateAutoIndexName(tableName, ++i));
            }
        }
        List<ISqlJetTableConstraint> constraints = tableDef.getConstraints();
        if (null != constraints) {
            for (ISqlJetTableConstraint constraint : constraints) {
                if (constraint instanceof ISqlJetTablePrimaryKey) {
                    boolean b = false;
                    ISqlJetTablePrimaryKey pk = (ISqlJetTablePrimaryKey)constraint;
                    if (pk.getColumns().size() == 1) {
                        String n = pk.getColumns().get(0);
                        ISqlJetColumnDef c = tableDef.getColumn(n);
                        boolean bl = b = c != null && c.hasExactlyIntegerType();
                    }
                    if (b) continue;
                    this.createAutoIndex(schemaTable, tableName, SqlJetBtreeTable.generateAutoIndexName(tableName, ++i));
                    continue;
                }
                if (!(constraint instanceof ISqlJetTableUnique)) continue;
                this.createAutoIndex(schemaTable, tableName, SqlJetBtreeTable.generateAutoIndexName(tableName, ++i));
            }
        }
    }

    private void checkSequenceTable() throws SqlJetException {
        if (!this.getTableNames().contains(SQLITE_SEQUENCE)) {
            this.createTableSafe(CREATE_TABLE_SQLITE_SEQUENCE);
        }
    }

    public ISqlJetBtreeDataTable openSequenceTable() throws SqlJetException {
        if (this.getTableNames().contains(SQLITE_SEQUENCE)) {
            return new SqlJetBtreeDataTable(this, SQLITE_SEQUENCE, true);
        }
        return null;
    }

    private void createAutoIndex(SqlJetBtreeTable schemaTable, String tableName, String autoIndexName) throws SqlJetException {
        int page = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
        ISqlJetBtreeRecord record = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), INDEX_TYPE, autoIndexName, tableName, page, null);
        ByteBuffer pData = record.getRawRecord();
        schemaTable.getCursor().insert(null, schemaTable.newRowId(), pData, pData.remaining(), 0, false);
        SqlJetBaseIndexDef indexDef = new SqlJetBaseIndexDef(autoIndexName, tableName, page);
        indexDef.setRowId(schemaTable.getCursor().getKeySize());
        this.indexDefs.put(autoIndexName, indexDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetIndexDef createIndex(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.createIndexSafe(sql);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetIndexDef createIndexSafe(String sql) throws SqlJetException {
        CommonTree ast = this.parseIndex(sql);
        SqlJetIndexDef indexDef = new SqlJetIndexDef(ast, 0);
        if (null == indexDef.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String indexName = indexDef.getName().trim();
        if ("".equals(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.indexDefs.containsKey(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index \"" + indexName + "\" exists already");
        }
        if (null == indexDef.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = indexDef.getTableName().trim();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        List<ISqlJetIndexedColumn> columns = indexDef.getColumns();
        if (null == columns) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        ISqlJetTableDef tableDef = this.getTable(tableName);
        if (null == tableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        for (ISqlJetIndexedColumn column : columns) {
            if (null == column.getName()) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            String columnName = column.getName().trim();
            if ("".equals(columnName)) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            if (null != tableDef.getColumn(columnName)) continue;
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Column \"" + columnName + "\" not found in table \"" + tableName + "\"");
        }
        SqlJetBtreeTable schemaTable = new SqlJetBtreeTable(this.db, this.btree, 1, true, false);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int page = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
                ISqlJetBtreeRecord record = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), INDEX_TYPE, indexName, tableName, page, indexDef.toSQL());
                ByteBuffer pData = record.getRawRecord();
                long rowId = schemaTable.newRowId();
                schemaTable.getCursor().insert(null, rowId, pData, pData.remaining(), 0, false);
                indexDef.setPage(page);
                indexDef.setRowId(rowId);
                this.indexDefs.put(indexName, indexDef);
                SqlJetBtreeIndexTable indexTable = new SqlJetBtreeIndexTable(this, indexDef.getName(), true);
                try {
                    indexTable.reindex(this);
                }
                finally {
                    indexTable.close();
                }
                SqlJetIndexDef sqlJetIndexDef = indexDef;
                schemaTable.unlock();
                return sqlJetIndexDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
        }
        finally {
            schemaTable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String tableName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropTableSafe(tableName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableSafe(String tableName) throws SqlJetException {
        if (null == tableName || "".equals(tableName.trim())) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name must be not empty");
        }
        if (!this.tableDefs.containsKey(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table not found: " + tableName);
        }
        SqlJetTableDef tableDef = (SqlJetTableDef)this.tableDefs.get(tableName);
        this.dropTableIndexes(tableDef);
        SqlJetBtreeTable schemaTable = new SqlJetBtreeTable(this.db, this.btree, 1, true, false);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                ISqlJetBtreeCursor cursor = schemaTable.getCursor();
                if (cursor.moveTo(null, tableDef.getRowId(), false) == -1) {
                    schemaTable.next();
                }
                if (!TABLE_TYPE.equals(schemaTable.getString(0))) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String n = schemaTable.getString(1);
                if (null == n || !tableName.equals(n)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                cursor.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        int page = tableDef.getPage();
        int moved = this.btree.dropTable(page);
        if (moved != 0) {
            this.movePage(page, moved);
        }
        this.tableDefs.remove(tableName);
    }

    private void dropTableIndexes(SqlJetTableDef tableDef) throws SqlJetException {
        String tableName = tableDef.getName().trim();
        Iterator<Map.Entry<String, ISqlJetIndexDef>> iterator = this.indexDefs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ISqlJetIndexDef> indexDefEntry = iterator.next();
            String indexName = indexDefEntry.getKey();
            ISqlJetIndexDef indexDef = indexDefEntry.getValue();
            if (!indexDef.getTableName().trim().equals(tableName) || !this.doDropIndex(indexName, true, false)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDropIndex(String indexName, boolean allowAutoIndex, boolean throwIfFial) throws SqlJetException {
        if (!this.indexDefs.containsKey(indexName)) {
            if (!throwIfFial) return false;
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
        SqlJetBaseIndexDef indexDef = (SqlJetBaseIndexDef)this.indexDefs.get(indexName);
        if (!allowAutoIndex && indexDef.isImplicit()) {
            if (!throwIfFial) return false;
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, indexName));
        }
        SqlJetBtreeTable schemaTable = new SqlJetBtreeTable(this.db, this.btree, 1, true, false);
        try {
            schemaTable.lock();
            try {
                ISqlJetBtreeCursor cursor = schemaTable.getCursor();
                if (cursor.moveTo(null, indexDef.getRowId(), false) == -1) {
                    schemaTable.next();
                }
                if (!INDEX_TYPE.equals(schemaTable.getString(0))) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl = false;
                    return bl;
                }
                String n = schemaTable.getString(1);
                if (null == n || !indexName.equals(n)) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (!allowAutoIndex && schemaTable.isNull(4)) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, indexName));
                    }
                    boolean bl = false;
                    return bl;
                }
                cursor.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        int page = indexDef.getPage();
        int moved = this.btree.dropTable(page);
        if (moved == 0) return true;
        this.movePage(page, moved);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePage(int page, int moved) throws SqlJetException {
        SqlJetBtreeTable schemaTable = new SqlJetBtreeTable(this.db, this.btree, 1, true, false);
        try {
            schemaTable.lock();
            try {
                schemaTable.first();
                while (!schemaTable.eof()) {
                    ISqlJetBtreeRecord record = schemaTable.getRecord();
                    long pageField = record.getIntField(3);
                    if (pageField == (long)moved) {
                        String name = record.getStringField(1, this.db.getOptions().getEncoding());
                        ISqlJetBtreeCursor cursor = schemaTable.getCursor();
                        long rowId = cursor.getKeySize();
                        record.getFields().get(3).setInt64(page);
                        ByteBuffer pData = record.getRawRecord();
                        cursor.delete();
                        cursor.insert(null, rowId, pData, pData.remaining(), 0, false);
                        ISqlJetIndexDef index = this.getIndex(name);
                        if (index != null) {
                            if (index instanceof SqlJetBaseIndexDef) {
                                ((SqlJetBaseIndexDef)index).setPage(page);
                            }
                        } else {
                            ISqlJetTableDef table = this.getTable(name);
                            if (table != null && table instanceof SqlJetTableDef) {
                                ((SqlJetTableDef)table).setPage(page);
                            }
                        }
                        return;
                    }
                    schemaTable.next();
                }
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String indexName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropIndexSafe(indexName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    private void dropIndexSafe(String indexName) throws SqlJetException {
        if (null == indexName || "".equals(indexName.trim())) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index name must be not empty");
        }
        if (!this.indexDefs.containsKey(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + indexName);
        }
        if (this.doDropIndex(indexName, false, true)) {
            this.db.getOptions().changeSchemaVersion();
            this.indexDefs.remove(indexName);
        }
    }
}

