package de.ugoe.cs.swe.exercises.settings;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SettingsDialog2 extends TitleAreaDialog {

	public SettingsDialog2(Shell parentShell) {
		super(parentShell);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle("Settings");
		Composite area = (Composite) super.createDialogArea(parent);
		{
			TabFolder tabFolder = new TabFolder(area, SWT.NONE);
			tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
			{
				TabItem tbtmSettings = new TabItem(tabFolder, SWT.NONE);
				tbtmSettings.setText("Settings");
				{
					Composite composite = new SettingsComposite(tabFolder, SWT.NONE);
					tbtmSettings.setControl(composite);
				}
			}
			{
				TabItem tbtmProfiledSettings = new TabItem(tabFolder, SWT.NONE);
				tbtmProfiledSettings.setText("Profiled Settings");
				{
					Composite composite = new SettingsProfileComposite(tabFolder, SWT.NONE);
					tbtmProfiledSettings.setControl(composite);
				}
			}
		}

		return area;
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	@Override
	protected Point getInitialSize() {
		return new Point(554, 547);
	}

}
