package de.ugoe.cs.swe.exercises.settings;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Button;

public class SettingsComposite extends Composite {
	private Text svnLocationText;
	private Text svnWorkingCopyText;
	private Text svnUsernameText;
	private Text svnPasswordText;
	private Text mysqlHostText;
	private Text mysqlDatabaseText;
	private Text mysqlUsernameText;
	private Text mysqlPasswordText;
	private Text pdfLatexText;
	private Text researchGroupText;
	private Text researchGroupUrlText;

	public SettingsComposite(Composite parent, int style) {
		super(parent, SWT.NONE);
		setLayout(new GridLayout(3, false));
		{
			Label lblSvnLocation = new Label(this, SWT.NONE);
			lblSvnLocation.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblSvnLocation.setText("SVN Location");
		}
		{
			svnLocationText = new Text(this, SWT.BORDER);
			svnLocationText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblSvnWorkingCopy = new Label(this, SWT.NONE);
			lblSvnWorkingCopy.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblSvnWorkingCopy.setText("SVN Working Copy");
		}
		{
			svnWorkingCopyText = new Text(this, SWT.BORDER);
			svnWorkingCopyText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		{
			Button btnBrowseSVNWorkingCopy = new Button(this, SWT.NONE);
			btnBrowseSVNWorkingCopy.setText("Browse");
		}
		{
			Label lblSvnUsername = new Label(this, SWT.NONE);
			lblSvnUsername.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblSvnUsername.setText("SVN Username");
		}
		{
			svnUsernameText = new Text(this, SWT.BORDER);
			svnUsernameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblSvnPassword = new Label(this, SWT.NONE);
			lblSvnPassword.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblSvnPassword.setText("SVN Password");
		}
		{
			svnPasswordText = new Text(this, SWT.BORDER | SWT.PASSWORD);
			svnPasswordText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
			label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlHost = new Label(this, SWT.NONE);
			lblMysqlHost.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblMysqlHost.setText("MySQL Host");
		}
		{
			mysqlHostText = new Text(this, SWT.BORDER);
			mysqlHostText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlDatabase = new Label(this, SWT.NONE);
			lblMysqlDatabase.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblMysqlDatabase.setText("MySQL Database");
		}
		{
			mysqlDatabaseText = new Text(this, SWT.BORDER);
			mysqlDatabaseText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlUsername = new Label(this, SWT.NONE);
			lblMysqlUsername.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblMysqlUsername.setText("MySQL Username");
		}
		{
			mysqlUsernameText = new Text(this, SWT.BORDER);
			mysqlUsernameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlPassword = new Label(this, SWT.NONE);
			lblMysqlPassword.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblMysqlPassword.setText("MySQL Password");
		}
		{
			mysqlPasswordText = new Text(this, SWT.BORDER);
			mysqlPasswordText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblMysqlSsl = new Label(this, SWT.NONE);
			lblMysqlSsl.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblMysqlSsl.setText("MySQL SSL");
		}
		{
			Combo mysqlSSLCombo = new Combo(this, SWT.NONE);
			mysqlSSLCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
			label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblPdfLatexPath = new Label(this, SWT.NONE);
			lblPdfLatexPath.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblPdfLatexPath.setText("pdfLatex Path");
		}
		{
			pdfLatexText = new Text(this, SWT.BORDER);
			pdfLatexText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		{
			Button btnBrowsePdfLatex = new Button(this, SWT.NONE);
			btnBrowsePdfLatex.setText("Browse");
		}
		{
			Label label = new Label(this, SWT.SEPARATOR | SWT.HORIZONTAL);
			label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblResearchGroup = new Label(this, SWT.NONE);
			lblResearchGroup.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblResearchGroup.setText("Research Group");
		}
		{
			researchGroupText = new Text(this, SWT.BORDER);
			researchGroupText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);
		{
			Label lblResearchGroupUrl = new Label(this, SWT.NONE);
			lblResearchGroupUrl.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
			lblResearchGroupUrl.setText("Research Group URL");
		}
		{
			researchGroupUrlText = new Text(this, SWT.BORDER);
			researchGroupUrlText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}
		new Label(this, SWT.NONE);

	}

	@Override
	protected void checkSubclass() {
	}

}
