package de.ugoe.cs.swe.exercises.exercisesheet;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExerciseSheetErrorDialog extends TitleAreaDialog {

	private Shell shell;

	public ExerciseSheetErrorDialog(Shell parentShell) {
		super(parentShell);
		super.setShellStyle(0);
		this.shell = parentShell;
		shell.setEnabled(false);
	}

	@Override
	protected Control createContents(Composite parent) {
		Control contents = super.createContents(parent);
		setTitle("Error");
		setMessage("An Error has occured!", IMessageProvider.INFORMATION);
		return contents;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		GridLayout layout = new GridLayout(SWT.CENTER, false);
		layout.numColumns = 1;
		parent.setLayout(layout);
		Label labelTitle = new Label(parent, SWT.CENTER);
		labelTitle.setAlignment(SWT.CENTER);
		labelTitle.setText("Files not found!");

		// GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		// gd.horizontalSpan = 1;
		// gd.verticalAlignment = SWT.CENTER;
		return parent;

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		((GridLayout) parent.getLayout()).numColumns = 1;

		GridData buttonlayout = new GridData(SWT.CENTER, SWT.CENTER, true, true);
		buttonlayout.minimumWidth = 200;
		Button buttonOk = new Button(parent, SWT.PUSH);
		buttonOk.setAlignment(SWT.CENTER);
		buttonOk.setText("OK");
		buttonOk.setFont(JFaceResources.getDialogFont());
		buttonOk.setLayoutData(buttonlayout);
		buttonOk.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.setEnabled(true);
				close();

			}
		});

	}
}