package de.ugoe.cs.swe.exercises.misc;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.ugoe.cs.swe.exercises.misc.CKeyword;

class KeywordContentProvider implements IStructuredContentProvider {
	private int type, modelId;
	
	public KeywordContentProvider(int type, Model model) {
		this.type = type;
		this.modelId = model.getId();
	}
	
	public KeywordContentProvider(int type) {
		this.type = type;
		this.modelId = -1;
	}
	
	public void inputChanged(Viewer v, Object oldInput, Object newInput) {
	}

	public void dispose() {
	}

	public Object[] getElements(Object parent) {
		return CKeyword.getKeywordsForModel(modelId, this.type).toArray();
	}
}
