package de.ugoe.cs.swe.exercises.lecture;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

import de.ugoe.cs.swe.exercises.exercise.Exercise;
import de.ugoe.cs.swe.exercises.exercisesheet.ExerciseSheet;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;


public class TreeComposite extends Composite {

	private Tree tree;
	
	public TreeComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(1, false));

		Composite composite = new Composite(this, SWT.NONE);
		{
			GridData gridData = new GridData(SWT.FILL, SWT.FILL, false, false,
					1, 1);
			gridData.widthHint = 440;
			gridData.heightHint = 233;
			composite.setLayoutData(gridData);
		}
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		composite.setLayout(gridLayout);
		
		tree = new Tree(parent, SWT.BORDER);
		tree.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});

		tree.setLinesVisible(true);
		refreshTree();
	
	}

	private void refreshTree() {
		tree.removeAll();

		ArrayList<Lecture> lectureList = Lecture.all();
		if (lectureList == null)
			return;
		ArrayList<LectureEvent> lectureEventList;
		ArrayList<ExerciseSheet> exerciseSheetList;
		ArrayList<Exercise> exerciseList;

		TreeItem lectureTree;
		TreeItem lectureEventTree;
		TreeItem exerciseSheetTree;
		TreeItem exerciseTree;

		for (int i = 0; i < lectureList.size(); i++) {
			lectureTree = new TreeItem(tree, SWT.NONE);
			lectureTree.setData(lectureList.get(i).getId());
			lectureTree.setText("" + lectureList.get(i).getName());

			lectureEventList = lectureList.get(i).getLectureEvents();
			if (lectureEventList == null)
				continue;
			for (int j = 0; j < lectureEventList.size(); j++) {
				lectureEventTree = new TreeItem(lectureTree, SWT.NONE);
				lectureEventTree.setData(lectureEventList.get(j).getId());
				String sem;
				if (lectureEventList.get(j).getIsSummerSemester())
					sem = "SS";
				else
					sem = "WS";
				lectureEventTree.setText(""
						+ lectureEventList.get(j).getLecture().getName() + " "
						+ sem + "" + lectureEventList.get(j).getSemester());

				exerciseSheetList = lectureEventList.get(j).getExerciseSheets();
				if (exerciseSheetList == null)
					continue;
				for (int k = 0; k < exerciseSheetList.size(); k++) {
					exerciseSheetTree = new TreeItem(lectureEventTree, SWT.NONE);
					exerciseSheetTree.setData(exerciseSheetList.get(k).getId());
					exerciseSheetTree.setText("Sheet "
							+ exerciseSheetList.get(k).getNumber());

					exerciseList = exerciseSheetList.get(k).getExercises();
					if (exerciseList == null)
						continue;
					for (int l = 0; l < exerciseList.size(); l++) {
						exerciseTree = new TreeItem(exerciseSheetTree, SWT.NONE);
						exerciseTree.setData(exerciseList.get(l).getId());
						exerciseTree.setText(""
								+ exerciseList.get(l).getTitle());
					}
				}
			}
		}
	}
	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
