/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import java.io.File;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetLimits;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.db.SqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.SqlJetOptions;
import org.tmatesoft.sqljet.core.internal.table.SqlJetPragmasHandler;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;

public class SqlJetDb
implements ISqlJetLimits {
    private static final BusyHandler busyHandler = new BusyHandler();
    private static final Set<SqlJetBtreeFlags> READ_FLAGS = SqlJetUtility.of(SqlJetBtreeFlags.READONLY);
    private static final Set<SqlJetFileOpenPermission> READ_PERMISSIONS = SqlJetUtility.of(SqlJetFileOpenPermission.READONLY);
    private static final Set<SqlJetBtreeFlags> WRITE_FLAGS = SqlJetUtility.of(SqlJetBtreeFlags.READWRITE, SqlJetBtreeFlags.CREATE);
    private static final Set<SqlJetFileOpenPermission> WRITE_PREMISSIONS = SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.CREATE);
    private final boolean writable;
    private ISqlJetDbHandle dbHandle;
    private ISqlJetBtree btree;
    private SqlJetSchema schema;
    private boolean transaction;
    private boolean open = false;

    protected SqlJetDb(File file, boolean writable) throws SqlJetException {
        this.writable = writable;
        this.dbHandle = new SqlJetDbHandle();
        this.dbHandle.setBusyHandler(busyHandler);
        this.btree = new SqlJetBtree();
        this.btree.open(file, this.dbHandle, writable ? WRITE_FLAGS : READ_FLAGS, SqlJetFileType.MAIN_DB, writable ? WRITE_PREMISSIONS : READ_PERMISSIONS);
        this.open = true;
        this.schema = (SqlJetSchema)this.runWithLock(new ISqlJetRunnableWithLock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetSchema schema = null;
                SqlJetDb.this.btree.enter();
                try {
                    SqlJetDb.this.dbHandle.setOptions(new SqlJetOptions(SqlJetDb.this.btree, SqlJetDb.this.dbHandle));
                    schema = new SqlJetSchema(SqlJetDb.this.dbHandle, SqlJetDb.this.btree);
                }
                finally {
                    SqlJetDb.this.btree.leave();
                }
                return schema;
            }
        });
    }

    public static SqlJetDb open(File file, boolean write) throws SqlJetException {
        return new SqlJetDb(file, write);
    }

    public boolean isOpen() {
        return this.open;
    }

    private void checkOpen() throws SqlJetException {
        if (!this.isOpen()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database closed");
        }
    }

    public void close() throws SqlJetException {
        if (this.open) {
            if (this.btree != null) {
                this.runWithLock(new ISqlJetRunnableWithLock(){

                    public Object runWithLock(SqlJetDb db) throws SqlJetException {
                        SqlJetDb.this.btree.close();
                        return null;
                    }
                });
                this.btree = null;
            }
            this.schema = null;
            this.dbHandle = null;
            this.open = false;
        }
    }

    public void setCacheSize(final int cacheSize) throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.btree.setCacheSize(cacheSize);
                return null;
            }
        });
    }

    public int getCacheSize() throws SqlJetException {
        this.checkOpen();
        return (Integer)this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.btree.getCacheSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runWithLock(ISqlJetRunnableWithLock op) throws SqlJetException {
        this.checkOpen();
        this.dbHandle.getMutex().enter();
        try {
            Object object = op.runWithLock(this);
            return object;
        }
        finally {
            this.dbHandle.getMutex().leave();
        }
    }

    public boolean isWritable() throws SqlJetException {
        this.checkOpen();
        return this.writable;
    }

    public ISqlJetSchema getSchema() throws SqlJetException {
        this.checkOpen();
        return this.schema;
    }

    public ISqlJetTable getTable(final String tableName) throws SqlJetException {
        this.checkOpen();
        return (SqlJetTable)this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetTable(db, SqlJetDb.this.schema, tableName, SqlJetDb.this.writable);
            }
        });
    }

    public Object runWriteTransaction(ISqlJetTransaction op) throws SqlJetException {
        this.checkOpen();
        if (this.writable) {
            return this.runTransaction(op, SqlJetTransactionMode.WRITE);
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Can't start write transaction on read-only database");
    }

    public Object runReadTransaction(ISqlJetTransaction op) throws SqlJetException {
        this.checkOpen();
        return this.runTransaction(op, SqlJetTransactionMode.READ_ONLY);
    }

    public Object runTransaction(final ISqlJetTransaction op, final SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        return this.runWithLock(new ISqlJetRunnableWithLock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                if (SqlJetDb.this.transaction) {
                    return op.run(SqlJetDb.this);
                }
                SqlJetDb.this.beginTransaction(mode);
                boolean success = false;
                try {
                    Object result = op.run(SqlJetDb.this);
                    SqlJetDb.this.btree.commit();
                    success = true;
                    Object object = result;
                    return object;
                }
                finally {
                    if (!success) {
                        SqlJetDb.this.btree.rollback();
                    }
                    SqlJetDb.this.transaction = false;
                }
            }
        });
    }

    public void beginTransaction(final SqlJetTransactionMode mode) throws SqlJetException {
        this.checkOpen();
        this.getOptions().verifySchemaVersion(true);
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                if (SqlJetDb.this.transaction) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Transaction already started");
                }
                SqlJetDb.this.btree.beginTrans(mode);
                SqlJetDb.this.transaction = true;
                return null;
            }
        });
    }

    public void commit() throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                if (!SqlJetDb.this.transaction) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Transaction wasn't started");
                }
                SqlJetDb.this.btree.commit();
                SqlJetDb.this.transaction = false;
                return null;
            }
        });
    }

    public void rollback() throws SqlJetException {
        this.checkOpen();
        this.runWithLock(new ISqlJetRunnableWithLock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                if (SqlJetDb.this.transaction) {
                    try {
                        SqlJetDb.this.btree.rollback();
                    }
                    finally {
                        SqlJetDb.this.transaction = false;
                    }
                } else {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Transaction wasn't started");
                }
                return null;
            }
        });
    }

    public ISqlJetOptions getOptions() throws SqlJetException {
        this.checkOpen();
        return this.dbHandle.getOptions();
    }

    public Object pragma(final String sql) throws SqlJetException {
        this.checkOpen();
        return this.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetPragmasHandler(SqlJetDb.this.getOptions()).pragma(sql);
            }
        });
    }

    public ISqlJetTableDef createTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.schema.createTable(sql);
            }
        });
    }

    public ISqlJetIndexDef createIndex(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetIndexDef)this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.schema.createIndex(sql);
            }
        });
    }

    public void dropTable(final String tableName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.schema.dropTable(tableName);
                return null;
            }
        });
    }

    public void dropIndex(final String indexName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.schema.dropIndex(indexName);
                return null;
            }
        });
    }

    private static final class BusyHandler
    implements ISqlJetBusyHandler {
        private static final int TRANSACTION_BUSY_RETRIES = SqlJetUtility.getIntSysProp("SQLJET.TRANSACTION_BUSY_RETRIES", 1000);
        private static final int TRANSACTION_BUSY_SLEEP = SqlJetUtility.getIntSysProp("SQLJET.TRANSACTION_BUSY_SLEEP", 1);

        private BusyHandler() {
        }

        public boolean call(int number) {
            try {
                Thread.sleep(TRANSACTION_BUSY_SLEEP);
            }
            catch (InterruptedException e) {
                return false;
            }
            return number <= TRANSACTION_BUSY_RETRIES;
        }
    }
}

