/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexOrderCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexScopeCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetReverseOrderCursor;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTableDataCursor;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetTable
implements ISqlJetTable {
    private final SqlJetDb db;
    private ISqlJetSchema schema;
    private String tableName;
    private boolean write;
    private ISqlJetTableDef tableDef;

    public SqlJetTable(SqlJetDb db, ISqlJetSchema schema, String tableName, boolean write) throws SqlJetException {
        this.db = db;
        this.schema = schema;
        this.tableName = tableName;
        this.write = write;
        this.tableDef = schema.getTable(tableName);
        if (null == this.tableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table not found: " + tableName);
        }
    }

    @Override
    public String getPrimaryKeyIndexName() throws SqlJetException {
        return this.tableDef.isRowIdPrimaryKey() ? null : this.tableDef.getPrimaryKeyIndexName();
    }

    @Override
    public ISqlJetTableDef getDefinition() throws SqlJetException {
        return this.tableDef;
    }

    @Override
    public ISqlJetCursor open() throws SqlJetException {
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetTableDataCursor(new SqlJetBtreeDataTable(SqlJetTable.this.schema, SqlJetTable.this.tableName, SqlJetTable.this.write), db);
            }
        });
    }

    @Override
    public ISqlJetCursor lookup(final String indexName, final Object ... key) throws SqlJetException {
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetIndexScopeCursor(new SqlJetBtreeDataTable(SqlJetTable.this.schema, SqlJetTable.this.tableName, SqlJetTable.this.write), db, indexName, key, key);
            }
        });
    }

    private Object runWriteTransaction(final ISqlJetTableRun op) throws SqlJetException {
        return this.db.runWriteTransaction(new ISqlJetTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(SqlJetTable.this.schema, SqlJetTable.this.tableName, SqlJetTable.this.write);
                try {
                    Object object = op.run(table);
                    return object;
                }
                finally {
                    table.close();
                }
            }
        });
    }

    @Override
    public long insert(final Object ... values) throws SqlJetException {
        return (Long)this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                return table.insert(values);
            }
        });
    }

    @Override
    public long insertByFieldNames(final Map<String, Object> values) throws SqlJetException {
        return (Long)this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                return table.insert(values);
            }
        });
    }

    @Override
    public long insertWithRowId(final long rowId, final Object ... values) throws SqlJetException {
        return (Long)this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                return table.insertWithRowId(rowId, values);
            }
        });
    }

    @Override
    public ISqlJetCursor order(final String indexName) throws SqlJetException {
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetIndexOrderCursor(new SqlJetBtreeDataTable(SqlJetTable.this.schema, SqlJetTable.this.tableName, SqlJetTable.this.write), db, indexName);
            }
        });
    }

    @Override
    public ISqlJetCursor scope(final String indexName, final Object[] firstKey, final Object[] lastKey) throws SqlJetException {
        return (ISqlJetCursor)this.db.runWithLock(new ISqlJetRunnableWithLock(){

            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                SqlJetBtreeDataTable table = new SqlJetBtreeDataTable(SqlJetTable.this.schema, SqlJetTable.this.tableName, SqlJetTable.this.write);
                if (SqlJetTable.this.isNeedReverse(indexName, firstKey, lastKey, table)) {
                    return new SqlJetReverseOrderCursor(new SqlJetIndexScopeCursor(table, db, indexName, lastKey, firstKey));
                }
                return new SqlJetIndexScopeCursor(table, db, indexName, firstKey, lastKey);
            }
        });
    }

    @Override
    public void clear() throws SqlJetException {
        this.runWriteTransaction(new ISqlJetTableRun(){

            public Object run(ISqlJetBtreeDataTable table) throws SqlJetException {
                table.clear();
                return null;
            }
        });
    }

    private boolean isNeedReverse(String indexName, Object[] firstKey, Object[] lastKey, SqlJetBtreeDataTable table) throws SqlJetException {
        if (firstKey != null && lastKey != null && firstKey.length > 0 && lastKey.length > 0) {
            String index;
            Object[] first = SqlJetUtility.adjustNumberTypes(firstKey);
            Object[] last = SqlJetUtility.adjustNumberTypes(lastKey);
            String string = index = indexName == null ? table.getPrimaryKeyIndex() : indexName;
            if (index != null) {
                ISqlJetBtreeIndexTable indexTable = table.getIndex(index);
                if (indexTable != null) {
                    return indexTable.compareKeys(first, last) < 0;
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Index \"%s\" doesn't exists", index));
            }
            if (first[0] instanceof Long && last[0] instanceof Long) {
                return ((Long)first[0]).compareTo((Long)last[0]) > 0;
            }
        }
        return false;
    }

    private static interface ISqlJetTableRun {
        public Object run(ISqlJetBtreeDataTable var1) throws SqlJetException;
    }
}

